@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin

import com.pulumi.azurenative.saas.SaasSubscriptionLevelArgs.builder
import com.pulumi.azurenative.saas.kotlin.inputs.SaasCreationPropertiesArgs
import com.pulumi.azurenative.saas.kotlin.inputs.SaasCreationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SaaS REST API resource definition.
 * Azure REST API version: 2018-03-01-beta. Prior API version in Azure Native 1.x: 2018-03-01-beta.
 * ## Example Usage
 * ### Create subscription level SaaS resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var saasSubscriptionLevel = new AzureNative.SaaS.SaasSubscriptionLevel("saasSubscriptionLevel", new()
 *     {
 *         Location = "global",
 *         Name = "MyContosoSubscription",
 *         Properties = new AzureNative.SaaS.Inputs.SaasCreationPropertiesArgs
 *         {
 *             OfferId = "contosoOffer",
 *             PaymentChannelMetadata =
 *             {
 *                 { "AzureSubscriptionId", "155af98a-3205-47e7-883b-a2ab9db9f88d" },
 *             },
 *             PaymentChannelType = "SubscriptionDelegated",
 *             PublisherId = "microsoft-contoso",
 *             SaasResourceName = "MyContosoSubscription",
 *             SkuId = "free",
 *             TermId = "hjdtn7tfnxcy",
 *         },
 *         ResourceGroupName = "my-saas-rg",
 *         ResourceName = "MyContosoSubscription",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/saas/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := saas.NewSaasSubscriptionLevel(ctx, "saasSubscriptionLevel", &saas.SaasSubscriptionLevelArgs{
 * 			Location: pulumi.String("global"),
 * 			Name:     pulumi.String("MyContosoSubscription"),
 * 			Properties: &saas.SaasCreationPropertiesArgs{
 * 				OfferId: pulumi.String("contosoOffer"),
 * 				PaymentChannelMetadata: pulumi.StringMap{
 * 					"AzureSubscriptionId": pulumi.String("155af98a-3205-47e7-883b-a2ab9db9f88d"),
 * 				},
 * 				PaymentChannelType: pulumi.String("SubscriptionDelegated"),
 * 				PublisherId:        pulumi.String("microsoft-contoso"),
 * 				SaasResourceName:   pulumi.String("MyContosoSubscription"),
 * 				SkuId:              pulumi.String("free"),
 * 				TermId:             pulumi.String("hjdtn7tfnxcy"),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-saas-rg"),
 * 			ResourceName:      pulumi.String("MyContosoSubscription"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.saas.SaasSubscriptionLevel;
 * import com.pulumi.azurenative.saas.SaasSubscriptionLevelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var saasSubscriptionLevel = new SaasSubscriptionLevel("saasSubscriptionLevel", SaasSubscriptionLevelArgs.builder()
 *             .location("global")
 *             .name("MyContosoSubscription")
 *             .properties(Map.ofEntries(
 *                 Map.entry("offerId", "contosoOffer"),
 *                 Map.entry("paymentChannelMetadata", Map.of("AzureSubscriptionId", "155af98a-3205-47e7-883b-a2ab9db9f88d")),
 *                 Map.entry("paymentChannelType", "SubscriptionDelegated"),
 *                 Map.entry("publisherId", "microsoft-contoso"),
 *                 Map.entry("saasResourceName", "MyContosoSubscription"),
 *                 Map.entry("skuId", "free"),
 *                 Map.entry("termId", "hjdtn7tfnxcy")
 *             ))
 *             .resourceGroupName("my-saas-rg")
 *             .resourceName("MyContosoSubscription")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:saas:SaasSubscriptionLevel MyContosoSubscription /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SaaS/resources/{resourceName}
 * ```
 * @property location Resource location. Only value allowed for SaaS is 'global'
 * @property name The resource name
 * @property properties Properties of the SaaS resource that are relevant for creation.
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the resource.
 * @property tags the resource tags.
 */
public data class SaasSubscriptionLevelArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<SaasCreationPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.saas.SaasSubscriptionLevelArgs> {
    override fun toJava(): com.pulumi.azurenative.saas.SaasSubscriptionLevelArgs =
        com.pulumi.azurenative.saas.SaasSubscriptionLevelArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SaasSubscriptionLevelArgs].
 */
@PulumiTagMarker
public class SaasSubscriptionLevelArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<SaasCreationPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource location. Only value allowed for SaaS is 'global'
     */
    @JvmName("jhpghbbumsovqggh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource name
     */
    @JvmName("umewyfvltojyxlkw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Properties of the SaaS resource that are relevant for creation.
     */
    @JvmName("nqruvrgaqbyijfja")
    public suspend fun properties(`value`: Output<SaasCreationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ixxougiaeurygdmu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("tvcxinxoajuwnowr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value the resource tags.
     */
    @JvmName("qwidwonikpkmlpuo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource location. Only value allowed for SaaS is 'global'
     */
    @JvmName("lwvswcotxferacvn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource name
     */
    @JvmName("akuqyxcptpnbmokl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Properties of the SaaS resource that are relevant for creation.
     */
    @JvmName("etvfsdxqlkbjstpq")
    public suspend fun properties(`value`: SaasCreationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the SaaS resource that are relevant for creation.
     */
    @JvmName("avrtvlvhnwfnmsyn")
    public suspend fun properties(argument: suspend SaasCreationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SaasCreationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("taabmevpkclsirdk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("pqjcnnfgdwftdxgp")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value the resource tags.
     */
    @JvmName("uxbarwiqgronjqcs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values the resource tags.
     */
    @JvmName("wucntqoerxyhftxi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SaasSubscriptionLevelArgs = SaasSubscriptionLevelArgs(
        location = location,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
