@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin.inputs

import com.pulumi.azurenative.saas.inputs.ListSaasResourceAccessTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceId The Saas resource ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
 */
public data class ListSaasResourceAccessTokenPlainArgs(
    public val resourceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.saas.inputs.ListSaasResourceAccessTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.saas.inputs.ListSaasResourceAccessTokenPlainArgs =
        com.pulumi.azurenative.saas.inputs.ListSaasResourceAccessTokenPlainArgs.builder()
            .resourceId(resourceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSaasResourceAccessTokenPlainArgs].
 */
@PulumiTagMarker
public class ListSaasResourceAccessTokenPlainArgsBuilder internal constructor() {
    private var resourceId: String? = null

    /**
     * @param value The Saas resource ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
     */
    @JvmName("neghpovaohcwhrgl")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    internal fun build(): ListSaasResourceAccessTokenPlainArgs = ListSaasResourceAccessTokenPlainArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
