@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin

import com.pulumi.azurenative.scheduler.JobArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.inputs.JobPropertiesArgs
import com.pulumi.azurenative.scheduler.kotlin.inputs.JobPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scheduler:Job myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}
 * ```
 * @property jobCollectionName The job collection name.
 * @property jobName The job name.
 * @property properties Gets or sets the job properties.
 * @property resourceGroupName The resource group name.
 */
public data class JobArgs(
    public val jobCollectionName: Output<String>? = null,
    public val jobName: Output<String>? = null,
    public val properties: Output<JobPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.JobArgs =
        com.pulumi.azurenative.scheduler.JobArgs.builder()
            .jobCollectionName(jobCollectionName?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var jobCollectionName: Output<String>? = null

    private var jobName: Output<String>? = null

    private var properties: Output<JobPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The job collection name.
     */
    @JvmName("jyvesssmypcbssgg")
    public suspend fun jobCollectionName(`value`: Output<String>) {
        this.jobCollectionName = value
    }

    /**
     * @param value The job name.
     */
    @JvmName("eimyxdfhvyndacgi")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Gets or sets the job properties.
     */
    @JvmName("ahpyvktikqyjrysh")
    public suspend fun properties(`value`: Output<JobPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("byvdsengrhcbedwf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The job collection name.
     */
    @JvmName("cjxryfuikvrjwrin")
    public suspend fun jobCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobCollectionName = mapped
    }

    /**
     * @param value The job name.
     */
    @JvmName("allfinqnrrxjclum")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Gets or sets the job properties.
     */
    @JvmName("mbrxncmixvmuhnlj")
    public suspend fun properties(`value`: JobPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Gets or sets the job properties.
     */
    @JvmName("qmsssavgbprxwhik")
    public suspend fun properties(argument: suspend JobPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = JobPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("rrhcvfcygrnchfdv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        jobCollectionName = jobCollectionName,
        jobName = jobName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
