@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobCollectionPropertiesArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.JobCollectionState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property quota Gets or sets the job collection quota.
 * @property sku Gets or sets the SKU.
 * @property state Gets or sets the state.
 */
public data class JobCollectionPropertiesArgs(
    public val quota: Output<JobCollectionQuotaArgs>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val state: Output<JobCollectionState>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobCollectionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.JobCollectionPropertiesArgs =
        com.pulumi.azurenative.scheduler.inputs.JobCollectionPropertiesArgs.builder()
            .quota(quota?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobCollectionPropertiesArgs].
 */
@PulumiTagMarker
public class JobCollectionPropertiesArgsBuilder internal constructor() {
    private var quota: Output<JobCollectionQuotaArgs>? = null

    private var sku: Output<SkuArgs>? = null

    private var state: Output<JobCollectionState>? = null

    /**
     * @param value Gets or sets the job collection quota.
     */
    @JvmName("ilgofmliqswvrpbj")
    public suspend fun quota(`value`: Output<JobCollectionQuotaArgs>) {
        this.quota = value
    }

    /**
     * @param value Gets or sets the SKU.
     */
    @JvmName("ksdfumlkwssnvnfq")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Gets or sets the state.
     */
    @JvmName("hwjjqsrhmitlbqne")
    public suspend fun state(`value`: Output<JobCollectionState>) {
        this.state = value
    }

    /**
     * @param value Gets or sets the job collection quota.
     */
    @JvmName("wlksljvjwyndttfm")
    public suspend fun quota(`value`: JobCollectionQuotaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quota = mapped
    }

    /**
     * @param argument Gets or sets the job collection quota.
     */
    @JvmName("ndtsanvnhenykjdb")
    public suspend fun quota(argument: suspend JobCollectionQuotaArgsBuilder.() -> Unit) {
        val toBeMapped = JobCollectionQuotaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quota = mapped
    }

    /**
     * @param value Gets or sets the SKU.
     */
    @JvmName("wqqjfvjsydgwmlwt")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Gets or sets the SKU.
     */
    @JvmName("eiafcrmugeilqisb")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Gets or sets the state.
     */
    @JvmName("jinweydewwuqvgnc")
    public suspend fun state(`value`: JobCollectionState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): JobCollectionPropertiesArgs = JobCollectionPropertiesArgs(
        quota = quota,
        sku = sku,
        state = state,
    )
}
