@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxJobCount Gets or set the maximum job count.
 * @property maxJobOccurrence Gets or sets the maximum job occurrence.
 * @property maxRecurrence Gets or set the maximum recurrence.
 */
public data class JobCollectionQuotaResponse(
    public val maxJobCount: Int? = null,
    public val maxJobOccurrence: Int? = null,
    public val maxRecurrence: JobMaxRecurrenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobCollectionQuotaResponse):
            JobCollectionQuotaResponse = JobCollectionQuotaResponse(
            maxJobCount = javaType.maxJobCount().map({ args0 -> args0 }).orElse(null),
            maxJobOccurrence = javaType.maxJobOccurrence().map({ args0 -> args0 }).orElse(null),
            maxRecurrence = javaType.maxRecurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.JobMaxRecurrenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
