@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin

import com.pulumi.azurenative.scom.InstanceArgs.builder
import com.pulumi.azurenative.scom.kotlin.inputs.ManagedIdentityArgs
import com.pulumi.azurenative.scom.kotlin.inputs.ManagedIdentityArgsBuilder
import com.pulumi.azurenative.scom.kotlin.inputs.MonitoringInstancePropertiesArgs
import com.pulumi.azurenative.scom.kotlin.inputs.MonitoringInstancePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SCOM instance resource
 * Azure REST API version: 2023-07-07-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scom:Instance myInstace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scom/managedInstances/{instanceName}
 * ```
 * @property identity The Azure Active Directory identity of the SCOM instance
 * @property instanceName Name of the Azure Monitor Operations Manager Managed Instance (SCOM MI)
 * @property location The geo-location where the resource lives
 * @property properties The properties of a SCOM instance resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property validationMode Validation mode for the SCOM managed instance
 */
public data class InstanceArgs(
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val instanceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<MonitoringInstancePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validationMode: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.InstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.InstanceArgs =
        com.pulumi.azurenative.scom.InstanceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validationMode(validationMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var identity: Output<ManagedIdentityArgs>? = null

    private var instanceName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<MonitoringInstancePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validationMode: Output<Boolean>? = null

    /**
     * @param value The Azure Active Directory identity of the SCOM instance
     */
    @JvmName("ljxxpwfjemhqnxjx")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Name of the Azure Monitor Operations Manager Managed Instance (SCOM MI)
     */
    @JvmName("jsdgbqxxkosuheya")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pprsobccxdldbaua")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The properties of a SCOM instance resource
     */
    @JvmName("imhgfrjmgmklrdrj")
    public suspend fun properties(`value`: Output<MonitoringInstancePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lffpiogffqxlojvf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dwiyimsqhaopswdy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Validation mode for the SCOM managed instance
     */
    @JvmName("brdflemxjsdhqlnl")
    public suspend fun validationMode(`value`: Output<Boolean>) {
        this.validationMode = value
    }

    /**
     * @param value The Azure Active Directory identity of the SCOM instance
     */
    @JvmName("hohdtmlwtkbpjwaj")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The Azure Active Directory identity of the SCOM instance
     */
    @JvmName("lkqegpyxckxrtlxw")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Name of the Azure Monitor Operations Manager Managed Instance (SCOM MI)
     */
    @JvmName("dyoethjekaveurpm")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wqivoxwpqffivsoj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The properties of a SCOM instance resource
     */
    @JvmName("whswqvtgfujbsmex")
    public suspend fun properties(`value`: MonitoringInstancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The properties of a SCOM instance resource
     */
    @JvmName("ilfchpbkadyanvcq")
    public suspend
    fun properties(argument: suspend MonitoringInstancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringInstancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yyyqvjyfbovflska")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("henfkvovgeewfpfl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("blfdqowiyooamnhn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Validation mode for the SCOM managed instance
     */
    @JvmName("kdorsffsbbuyptje")
    public suspend fun validationMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationMode = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        identity = identity,
        instanceName = instanceName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        validationMode = validationMode,
    )
}
