@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin

import com.pulumi.azurenative.scom.ScomFunctions.getInstancePlain
import com.pulumi.azurenative.scom.ScomFunctions.getManagedGatewayPlain
import com.pulumi.azurenative.scom.ScomFunctions.getMonitoredResourcePlain
import com.pulumi.azurenative.scom.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.azurenative.scom.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.azurenative.scom.kotlin.inputs.GetManagedGatewayPlainArgs
import com.pulumi.azurenative.scom.kotlin.inputs.GetManagedGatewayPlainArgsBuilder
import com.pulumi.azurenative.scom.kotlin.inputs.GetMonitoredResourcePlainArgs
import com.pulumi.azurenative.scom.kotlin.inputs.GetMonitoredResourcePlainArgsBuilder
import com.pulumi.azurenative.scom.kotlin.outputs.GetInstanceResult
import com.pulumi.azurenative.scom.kotlin.outputs.GetManagedGatewayResult
import com.pulumi.azurenative.scom.kotlin.outputs.GetMonitoredResourceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scom.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.azurenative.scom.kotlin.outputs.GetManagedGatewayResult.Companion.toKotlin as getManagedGatewayResultToKotlin
import com.pulumi.azurenative.scom.kotlin.outputs.GetMonitoredResourceResult.Companion.toKotlin as getMonitoredResourceResultToKotlin

public object ScomFunctions {
    /**
     * Get SCOM managed instance details
     * Azure REST API version: 2023-07-07-preview.
     * @param argument null
     * @return A SCOM instance resource
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param instanceName Name of the Azure Monitor Operations Manager Managed Instance (SCOM MI)
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A SCOM instance resource
     */
    public suspend fun getInstance(instanceName: String, resourceGroupName: String):
        GetInstanceResult {
        val argument = GetInstancePlainArgs(
            instanceName = instanceName,
            resourceGroupName = resourceGroupName,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scom&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A SCOM instance resource
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit):
        GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the details of the gateway resource.
     * Azure REST API version: 2023-07-07-preview.
     * @param argument null
     * @return A gateway resource.
     */
    public suspend fun getManagedGateway(argument: GetManagedGatewayPlainArgs):
        GetManagedGatewayResult =
        getManagedGatewayResultToKotlin(getManagedGatewayPlain(argument.toJava()).await())

    /**
     * @see [getManagedGateway].
     * @param instanceName Name of the SCOM managed instance.
     * @param managedGatewayName The gateway resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A gateway resource.
     */
    public suspend fun getManagedGateway(
        instanceName: String,
        managedGatewayName: String,
        resourceGroupName: String,
    ): GetManagedGatewayResult {
        val argument = GetManagedGatewayPlainArgs(
            instanceName = instanceName,
            managedGatewayName = managedGatewayName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedGatewayResultToKotlin(getManagedGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedGateway].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scom&#46;kotlin&#46;inputs&#46;GetManagedGatewayPlainArgs].
     * @return A gateway resource.
     */
    public suspend
    fun getManagedGateway(argument: suspend GetManagedGatewayPlainArgsBuilder.() -> Unit):
        GetManagedGatewayResult {
        val builder = GetManagedGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedGatewayResultToKotlin(getManagedGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the details of the monitored resource.
     * Azure REST API version: 2023-07-07-preview.
     * @param argument null
     * @return A monitored resource.
     */
    public suspend fun getMonitoredResource(argument: GetMonitoredResourcePlainArgs):
        GetMonitoredResourceResult =
        getMonitoredResourceResultToKotlin(getMonitoredResourcePlain(argument.toJava()).await())

    /**
     * @see [getMonitoredResource].
     * @param instanceName Name of the SCOM managed instance.
     * @param monitoredResourceName The monitored resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A monitored resource.
     */
    public suspend fun getMonitoredResource(
        instanceName: String,
        monitoredResourceName: String,
        resourceGroupName: String,
    ): GetMonitoredResourceResult {
        val argument = GetMonitoredResourcePlainArgs(
            instanceName = instanceName,
            monitoredResourceName = monitoredResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getMonitoredResourceResultToKotlin(getMonitoredResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitoredResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scom&#46;kotlin&#46;inputs&#46;GetMonitoredResourcePlainArgs].
     * @return A monitored resource.
     */
    public suspend
    fun getMonitoredResource(argument: suspend GetMonitoredResourcePlainArgsBuilder.() -> Unit):
        GetMonitoredResourceResult {
        val builder = GetMonitoredResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitoredResourceResultToKotlin(getMonitoredResourcePlain(builtArgument.toJava()).await())
    }
}
