@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.DomainUserCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Get Domain user name and password from key vault
 * @property keyVaultUrl Key vault url to get the domain username and password
 * @property passwordSecret Domain Password secret
 * @property userNameSecret Domain user name secret
 */
public data class DomainUserCredentialsArgs(
    public val keyVaultUrl: Output<String>? = null,
    public val passwordSecret: Output<String>? = null,
    public val userNameSecret: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.DomainUserCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.DomainUserCredentialsArgs =
        com.pulumi.azurenative.scom.inputs.DomainUserCredentialsArgs.builder()
            .keyVaultUrl(keyVaultUrl?.applyValue({ args0 -> args0 }))
            .passwordSecret(passwordSecret?.applyValue({ args0 -> args0 }))
            .userNameSecret(userNameSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainUserCredentialsArgs].
 */
@PulumiTagMarker
public class DomainUserCredentialsArgsBuilder internal constructor() {
    private var keyVaultUrl: Output<String>? = null

    private var passwordSecret: Output<String>? = null

    private var userNameSecret: Output<String>? = null

    /**
     * @param value Key vault url to get the domain username and password
     */
    @JvmName("lgtdufbrfolbeyeq")
    public suspend fun keyVaultUrl(`value`: Output<String>) {
        this.keyVaultUrl = value
    }

    /**
     * @param value Domain Password secret
     */
    @JvmName("myydexmmirxqdenv")
    public suspend fun passwordSecret(`value`: Output<String>) {
        this.passwordSecret = value
    }

    /**
     * @param value Domain user name secret
     */
    @JvmName("cnhliojtnxqplsth")
    public suspend fun userNameSecret(`value`: Output<String>) {
        this.userNameSecret = value
    }

    /**
     * @param value Key vault url to get the domain username and password
     */
    @JvmName("jloqxjeextejtlnb")
    public suspend fun keyVaultUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUrl = mapped
    }

    /**
     * @param value Domain Password secret
     */
    @JvmName("bxukjdpchgoeqtgp")
    public suspend fun passwordSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordSecret = mapped
    }

    /**
     * @param value Domain user name secret
     */
    @JvmName("yeuqkbpwldhshtmo")
    public suspend fun userNameSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userNameSecret = mapped
    }

    internal fun build(): DomainUserCredentialsArgs = DomainUserCredentialsArgs(
        keyVaultUrl = keyVaultUrl,
        passwordSecret = passwordSecret,
        userNameSecret = userNameSecret,
    )
}
