@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties to maximize savings by using Azure Hybrid Benefit
 * @property scomLicenseType SCOM license type. Maximize savings by using license you already own
 * @property sqlServerLicenseType SQL Server license type. Maximize savings by using Azure Hybrid Benefit for SQL Server with license you already own
 * @property windowsServerLicenseType Specifies that the image or disk that is being used was licensed on-premises. <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json)
 */
public data class AzureHybridBenefitPropertiesResponse(
    public val scomLicenseType: String? = null,
    public val sqlServerLicenseType: String? = null,
    public val windowsServerLicenseType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scom.outputs.AzureHybridBenefitPropertiesResponse):
            AzureHybridBenefitPropertiesResponse = AzureHybridBenefitPropertiesResponse(
            scomLicenseType = javaType.scomLicenseType().map({ args0 -> args0 }).orElse(null),
            sqlServerLicenseType = javaType.sqlServerLicenseType().map({ args0 -> args0 }).orElse(null),
            windowsServerLicenseType = javaType.windowsServerLicenseType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
