@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.VMMServerPropertiesResponseCredentials
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.scvmm.kotlin.outputs.VMMServerPropertiesResponseCredentials.Companion.toKotlin as vMMServerPropertiesResponseCredentialsToKotlin

/**
 * Builder for [VmmServer].
 */
@PulumiTagMarker
public class VmmServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VmmServerArgs = VmmServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VmmServerArgsBuilder.() -> Unit) {
        val builder = VmmServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VmmServer {
        val builtJavaResource = com.pulumi.azurenative.scvmm.VmmServer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VmmServer(builtJavaResource)
    }
}

/**
 * The VmmServers resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateVMMServer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vmmServer = new AzureNative.ScVmm.VmmServer("vmmServer", new()
 *     {
 *         Credentials = new AzureNative.ScVmm.Inputs.VMMServerPropertiesCredentialsArgs
 *         {
 *             Password = "password",
 *             Username = "testuser",
 *         },
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Fqdn = "VMM.contoso.com",
 *         Location = "East US",
 *         Port = 1234,
 *         ResourceGroupName = "testrg",
 *         VmmServerName = "ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVmmServer(ctx, "vmmServer", &scvmm.VmmServerArgs{
 * 			Credentials: &scvmm.VMMServerPropertiesCredentialsArgs{
 * 				Password: pulumi.String("password"),
 * 				Username: pulumi.String("testuser"),
 * 			},
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Fqdn:              pulumi.String("VMM.contoso.com"),
 * 			Location:          pulumi.String("East US"),
 * 			Port:              pulumi.Int(1234),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VmmServerName:     pulumi.String("ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VmmServer;
 * import com.pulumi.azurenative.scvmm.VmmServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vmmServer = new VmmServer("vmmServer", VmmServerArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("password", "password"),
 *                 Map.entry("username", "testuser")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 *                 Map.entry("type", "customLocation")
 *             ))
 *             .fqdn("VMM.contoso.com")
 *             .location("East US")
 *             .port(1234)
 *             .resourceGroupName("testrg")
 *             .vmmServerName("ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VmmServer ContosoVMMServer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}
 * ```
 */
public class VmmServer internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.VmmServer,
) : KotlinCustomResource(javaResource, VmmServerMapper) {
    /**
     * Gets or sets the connection status to the vmmServer.
     */
    public val connectionStatus: Output<String>
        get() = javaResource.connectionStatus().applyValue({ args0 -> args0 })

    /**
     * Credentials to connect to VMMServer.
     */
    public val credentials: Output<VMMServerPropertiesResponseCredentials>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vMMServerPropertiesResponseCredentialsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets any error message if connection to vmmServer is having any issue.
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Fqdn is the hostname/ip of the vmmServer.
     */
    public val fqdn: Output<String>
        get() = javaResource.fqdn().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Port is the port on which the vmmServer is listening.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource Type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique ID of vmmServer.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })

    /**
     * Version is the version of the vmmSever.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object VmmServerMapper : ResourceMapper<VmmServer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.VmmServer::class == javaResource::class

    override fun map(javaResource: Resource): VmmServer = VmmServer(
        javaResource as
            com.pulumi.azurenative.scvmm.VmmServer,
    )
}

/**
 * @see [VmmServer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VmmServer].
 */
public suspend fun vmmServer(name: String, block: suspend VmmServerResourceBuilder.() -> Unit):
    VmmServer {
    val builder = VmmServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VmmServer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vmmServer(name: String): VmmServer {
    val builder = VmmServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
