@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.CheckpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the resource properties.
 * @property checkpointID Gets ID of the checkpoint.
 * @property description Gets description of the checkpoint.
 * @property name Gets name of the checkpoint.
 * @property parentCheckpointID Gets ID of parent of the checkpoint.
 */
public data class CheckpointArgs(
    public val checkpointID: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentCheckpointID: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.CheckpointArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.CheckpointArgs =
        com.pulumi.azurenative.scvmm.inputs.CheckpointArgs.builder()
            .checkpointID(checkpointID?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentCheckpointID(parentCheckpointID?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CheckpointArgs].
 */
@PulumiTagMarker
public class CheckpointArgsBuilder internal constructor() {
    private var checkpointID: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parentCheckpointID: Output<String>? = null

    /**
     * @param value Gets ID of the checkpoint.
     */
    @JvmName("vbvjthuylfkhqsbm")
    public suspend fun checkpointID(`value`: Output<String>) {
        this.checkpointID = value
    }

    /**
     * @param value Gets description of the checkpoint.
     */
    @JvmName("btxumuqnutlybocq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets name of the checkpoint.
     */
    @JvmName("ggpkougumkbbxmvr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets ID of parent of the checkpoint.
     */
    @JvmName("xngojwxppxxtqbjh")
    public suspend fun parentCheckpointID(`value`: Output<String>) {
        this.parentCheckpointID = value
    }

    /**
     * @param value Gets ID of the checkpoint.
     */
    @JvmName("ooxxywtygadddrui")
    public suspend fun checkpointID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointID = mapped
    }

    /**
     * @param value Gets description of the checkpoint.
     */
    @JvmName("cdyaosdsxlreiuid")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets name of the checkpoint.
     */
    @JvmName("rsvesaswqwrtpfaj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets ID of parent of the checkpoint.
     */
    @JvmName("hwvduwghbwbggriv")
    public suspend fun parentCheckpointID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentCheckpointID = mapped
    }

    internal fun build(): CheckpointArgs = CheckpointArgs(
        checkpointID = checkpointID,
        description = description,
        name = name,
        parentCheckpointID = parentCheckpointID,
    )
}
