@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetHybridIdentityMetadataPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metadataName Name of the HybridIdentityMetadata.
 * @property resourceGroupName The name of the resource group.
 * @property virtualMachineName Name of the vm.
 */
public data class GetHybridIdentityMetadataPlainArgs(
    public val metadataName: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetHybridIdentityMetadataPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetHybridIdentityMetadataPlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetHybridIdentityMetadataPlainArgs.builder()
            .metadataName(metadataName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridIdentityMetadataPlainArgs].
 */
@PulumiTagMarker
public class GetHybridIdentityMetadataPlainArgsBuilder internal constructor() {
    private var metadataName: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value Name of the HybridIdentityMetadata.
     */
    @JvmName("guwtbeycdhbvfxxj")
    public suspend fun metadataName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metadataName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ivfdjjwqevqskrhq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("rydwihaxeycrmtkq")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetHybridIdentityMetadataPlainArgs = GetHybridIdentityMetadataPlainArgs(
        metadataName = metadataName ?: throw PulumiNullFieldException("metadataName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
