@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetInventoryItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property inventoryItemName Name of the inventoryItem.
 * @property resourceGroupName The name of the resource group.
 * @property vmmServerName Name of the VMMServer.
 */
public data class GetInventoryItemPlainArgs(
    public val inventoryItemName: String,
    public val resourceGroupName: String,
    public val vmmServerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetInventoryItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetInventoryItemPlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetInventoryItemPlainArgs.builder()
            .inventoryItemName(inventoryItemName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmmServerName(vmmServerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInventoryItemPlainArgs].
 */
@PulumiTagMarker
public class GetInventoryItemPlainArgsBuilder internal constructor() {
    private var inventoryItemName: String? = null

    private var resourceGroupName: String? = null

    private var vmmServerName: String? = null

    /**
     * @param value Name of the inventoryItem.
     */
    @JvmName("csbkvglsjsnhhdcl")
    public suspend fun inventoryItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inventoryItemName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("uogicitjxrswvvob")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the VMMServer.
     */
    @JvmName("opjkspssqspdfkpl")
    public suspend fun vmmServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmmServerName = mapped
    }

    internal fun build(): GetInventoryItemPlainArgs = GetInventoryItemPlainArgs(
        inventoryItemName = inventoryItemName ?: throw PulumiNullFieldException("inventoryItemName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmmServerName = vmmServerName ?: throw PulumiNullFieldException("vmmServerName"),
    )
}
