@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetMachineExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property extensionName The name of the machine extension.
 * @property resourceGroupName The name of the resource group.
 * @property virtualMachineName The name of the machine where the extension should be created or updated.
 */
public data class GetMachineExtensionPlainArgs(
    public val extensionName: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetMachineExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetMachineExtensionPlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetMachineExtensionPlainArgs.builder()
            .extensionName(extensionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetMachineExtensionPlainArgsBuilder internal constructor() {
    private var extensionName: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value The name of the machine extension.
     */
    @JvmName("kidhlwxbcopmmwxs")
    public suspend fun extensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fdyqxbguxcaqihee")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the machine where the extension should be created or updated.
     */
    @JvmName("yapwniepdxaypeym")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetMachineExtensionPlainArgs = GetMachineExtensionPlainArgs(
        extensionName = extensionName ?: throw PulumiNullFieldException("extensionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
