@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.IdentityArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.enums.IdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed service identity.
 * @property type The type of managed service identity.
 */
public data class IdentityArgs(
    public val type: Output<Either<String, IdentityType>>,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.IdentityArgs =
        com.pulumi.azurenative.scvmm.inputs.IdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, IdentityType>>? = null

    /**
     * @param value The type of managed service identity.
     */
    @JvmName("ouffhujtwqmykcev")
    public suspend fun type(`value`: Output<Either<String, IdentityType>>) {
        this.type = value
    }

    /**
     * @param value The type of managed service identity.
     */
    @JvmName("nqidrtwmwkgesbby")
    public suspend fun type(`value`: Either<String, IdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed service identity.
     */
    @JvmName("tusiqcfmqvdscycb")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed service identity.
     */
    @JvmName("cbhcxbvmlshmviec")
    public fun type(`value`: IdentityType) {
        val toBeMapped = Either.ofRight<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
