@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.InfrastructureProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the vmmServer infrastructure specific settings for the virtual machine instance.
 * @property biosGuid Gets or sets the bios guid for the vm.
 * @property checkpointType Type of checkpoint supported for the vm.
 * @property checkpoints Checkpoints in the vm.
 * @property cloudId ARM Id of the cloud resource to use for deploying the vm.
 * @property generation Gets or sets the generation for the vm.
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property templateId ARM Id of the template resource to use for deploying the vm.
 * @property uuid Unique ID of the virtual machine.
 * @property vmName VMName is the name of VM on the SCVMM server.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class InfrastructureProfileArgs(
    public val biosGuid: Output<String>? = null,
    public val checkpointType: Output<String>? = null,
    public val checkpoints: Output<List<CheckpointArgs>>? = null,
    public val cloudId: Output<String>? = null,
    public val generation: Output<Int>? = null,
    public val inventoryItemId: Output<String>? = null,
    public val templateId: Output<String>? = null,
    public val uuid: Output<String>? = null,
    public val vmName: Output<String>? = null,
    public val vmmServerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.InfrastructureProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.InfrastructureProfileArgs =
        com.pulumi.azurenative.scvmm.inputs.InfrastructureProfileArgs.builder()
            .biosGuid(biosGuid?.applyValue({ args0 -> args0 }))
            .checkpointType(checkpointType?.applyValue({ args0 -> args0 }))
            .checkpoints(
                checkpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudId(cloudId?.applyValue({ args0 -> args0 }))
            .generation(generation?.applyValue({ args0 -> args0 }))
            .inventoryItemId(inventoryItemId?.applyValue({ args0 -> args0 }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .uuid(uuid?.applyValue({ args0 -> args0 }))
            .vmName(vmName?.applyValue({ args0 -> args0 }))
            .vmmServerId(vmmServerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InfrastructureProfileArgs].
 */
@PulumiTagMarker
public class InfrastructureProfileArgsBuilder internal constructor() {
    private var biosGuid: Output<String>? = null

    private var checkpointType: Output<String>? = null

    private var checkpoints: Output<List<CheckpointArgs>>? = null

    private var cloudId: Output<String>? = null

    private var generation: Output<Int>? = null

    private var inventoryItemId: Output<String>? = null

    private var templateId: Output<String>? = null

    private var uuid: Output<String>? = null

    private var vmName: Output<String>? = null

    private var vmmServerId: Output<String>? = null

    /**
     * @param value Gets or sets the bios guid for the vm.
     */
    @JvmName("oatybwkfxmubtaqe")
    public suspend fun biosGuid(`value`: Output<String>) {
        this.biosGuid = value
    }

    /**
     * @param value Type of checkpoint supported for the vm.
     */
    @JvmName("ftmvskkcjjthluql")
    public suspend fun checkpointType(`value`: Output<String>) {
        this.checkpointType = value
    }

    /**
     * @param value Checkpoints in the vm.
     */
    @JvmName("udkkewejdqttykem")
    public suspend fun checkpoints(`value`: Output<List<CheckpointArgs>>) {
        this.checkpoints = value
    }

    @JvmName("ptlqhpxayfxlnxyw")
    public suspend fun checkpoints(vararg values: Output<CheckpointArgs>) {
        this.checkpoints = Output.all(values.asList())
    }

    /**
     * @param values Checkpoints in the vm.
     */
    @JvmName("geyxthtndgnxkxor")
    public suspend fun checkpoints(values: List<Output<CheckpointArgs>>) {
        this.checkpoints = Output.all(values)
    }

    /**
     * @param value ARM Id of the cloud resource to use for deploying the vm.
     */
    @JvmName("rsolguujnbpfsqgy")
    public suspend fun cloudId(`value`: Output<String>) {
        this.cloudId = value
    }

    /**
     * @param value Gets or sets the generation for the vm.
     */
    @JvmName("dficiojxcmhwqbrc")
    public suspend fun generation(`value`: Output<Int>) {
        this.generation = value
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource.
     */
    @JvmName("qrcqmsilcpxdhtsr")
    public suspend fun inventoryItemId(`value`: Output<String>) {
        this.inventoryItemId = value
    }

    /**
     * @param value ARM Id of the template resource to use for deploying the vm.
     */
    @JvmName("batsdtdmkrvtyapa")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value Unique ID of the virtual machine.
     */
    @JvmName("pioffvhlxwluaidt")
    public suspend fun uuid(`value`: Output<String>) {
        this.uuid = value
    }

    /**
     * @param value VMName is the name of VM on the SCVMM server.
     */
    @JvmName("uhxqjkapqdnreuvy")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("yvgkfwldlrwrktlk")
    public suspend fun vmmServerId(`value`: Output<String>) {
        this.vmmServerId = value
    }

    /**
     * @param value Gets or sets the bios guid for the vm.
     */
    @JvmName("clsbxmpjhrjarfgf")
    public suspend fun biosGuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.biosGuid = mapped
    }

    /**
     * @param value Type of checkpoint supported for the vm.
     */
    @JvmName("ddjeijlldtekfupf")
    public suspend fun checkpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointType = mapped
    }

    /**
     * @param value Checkpoints in the vm.
     */
    @JvmName("oxjkahnsxyigccvt")
    public suspend fun checkpoints(`value`: List<CheckpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpoints = mapped
    }

    /**
     * @param argument Checkpoints in the vm.
     */
    @JvmName("joebhdsgijxxsrij")
    public suspend fun checkpoints(argument: List<suspend CheckpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { CheckpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.checkpoints = mapped
    }

    /**
     * @param argument Checkpoints in the vm.
     */
    @JvmName("hnlyrnvtyiaeoowx")
    public suspend fun checkpoints(vararg argument: suspend CheckpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { CheckpointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.checkpoints = mapped
    }

    /**
     * @param argument Checkpoints in the vm.
     */
    @JvmName("texiwloqmccbexkc")
    public suspend fun checkpoints(argument: suspend CheckpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CheckpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.checkpoints = mapped
    }

    /**
     * @param values Checkpoints in the vm.
     */
    @JvmName("eykhacjqlbolpgrq")
    public suspend fun checkpoints(vararg values: CheckpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkpoints = mapped
    }

    /**
     * @param value ARM Id of the cloud resource to use for deploying the vm.
     */
    @JvmName("wedipaohfpelajmb")
    public suspend fun cloudId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudId = mapped
    }

    /**
     * @param value Gets or sets the generation for the vm.
     */
    @JvmName("kwschekwovwxibcw")
    public suspend fun generation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generation = mapped
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource.
     */
    @JvmName("ibmlleovohmblsmj")
    public suspend fun inventoryItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemId = mapped
    }

    /**
     * @param value ARM Id of the template resource to use for deploying the vm.
     */
    @JvmName("chflkijubigsfskf")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value Unique ID of the virtual machine.
     */
    @JvmName("kvfhmoxlccnumsmg")
    public suspend fun uuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uuid = mapped
    }

    /**
     * @param value VMName is the name of VM on the SCVMM server.
     */
    @JvmName("oihgixhcqniyrmta")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("cmlasnrvjotimuch")
    public suspend fun vmmServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmmServerId = mapped
    }

    internal fun build(): InfrastructureProfileArgs = InfrastructureProfileArgs(
        biosGuid = biosGuid,
        checkpointType = checkpointType,
        checkpoints = checkpoints,
        cloudId = cloudId,
        generation = generation,
        inventoryItemId = inventoryItemId,
        templateId = templateId,
        uuid = uuid,
        vmName = vmName,
        vmmServerId = vmmServerId,
    )
}
