@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.NetworkInterfacesArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.enums.AllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network Interface model
 * @property ipv4AddressType Gets or sets the ipv4 address type.
 * @property ipv6AddressType Gets or sets the ipv6 address type.
 * @property macAddress Gets or sets the nic MAC address.
 * @property macAddressType Gets or sets the mac address type.
 * @property name Gets or sets the name of the network interface.
 * @property nicId Gets or sets the nic id.
 * @property virtualNetworkId Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork resource to connect the nic.
 */
public data class NetworkInterfacesArgs(
    public val ipv4AddressType: Output<Either<String, AllocationMethod>>? = null,
    public val ipv6AddressType: Output<Either<String, AllocationMethod>>? = null,
    public val macAddress: Output<String>? = null,
    public val macAddressType: Output<Either<String, AllocationMethod>>? = null,
    public val name: Output<String>? = null,
    public val nicId: Output<String>? = null,
    public val virtualNetworkId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.NetworkInterfacesArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.NetworkInterfacesArgs =
        com.pulumi.azurenative.scvmm.inputs.NetworkInterfacesArgs.builder()
            .ipv4AddressType(
                ipv4AddressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipv6AddressType(
                ipv6AddressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .macAddress(macAddress?.applyValue({ args0 -> args0 }))
            .macAddressType(
                macAddressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .nicId(nicId?.applyValue({ args0 -> args0 }))
            .virtualNetworkId(virtualNetworkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfacesArgs].
 */
@PulumiTagMarker
public class NetworkInterfacesArgsBuilder internal constructor() {
    private var ipv4AddressType: Output<Either<String, AllocationMethod>>? = null

    private var ipv6AddressType: Output<Either<String, AllocationMethod>>? = null

    private var macAddress: Output<String>? = null

    private var macAddressType: Output<Either<String, AllocationMethod>>? = null

    private var name: Output<String>? = null

    private var nicId: Output<String>? = null

    private var virtualNetworkId: Output<String>? = null

    /**
     * @param value Gets or sets the ipv4 address type.
     */
    @JvmName("lkuqyavwxrxeohhd")
    public suspend fun ipv4AddressType(`value`: Output<Either<String, AllocationMethod>>) {
        this.ipv4AddressType = value
    }

    /**
     * @param value Gets or sets the ipv6 address type.
     */
    @JvmName("jjxmqtaumwqyhdde")
    public suspend fun ipv6AddressType(`value`: Output<Either<String, AllocationMethod>>) {
        this.ipv6AddressType = value
    }

    /**
     * @param value Gets or sets the nic MAC address.
     */
    @JvmName("mnjjrvvdctvvnlbt")
    public suspend fun macAddress(`value`: Output<String>) {
        this.macAddress = value
    }

    /**
     * @param value Gets or sets the mac address type.
     */
    @JvmName("jtdmyadlxrbktnmg")
    public suspend fun macAddressType(`value`: Output<Either<String, AllocationMethod>>) {
        this.macAddressType = value
    }

    /**
     * @param value Gets or sets the name of the network interface.
     */
    @JvmName("oohhkykljxcdyomd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the nic id.
     */
    @JvmName("lkkvvcvrxpditysu")
    public suspend fun nicId(`value`: Output<String>) {
        this.nicId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork resource to connect the nic.
     */
    @JvmName("sheteahimsvuldyr")
    public suspend fun virtualNetworkId(`value`: Output<String>) {
        this.virtualNetworkId = value
    }

    /**
     * @param value Gets or sets the ipv4 address type.
     */
    @JvmName("lujmvoqwnaxwvkqk")
    public suspend fun ipv4AddressType(`value`: Either<String, AllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4AddressType = mapped
    }

    /**
     * @param value Gets or sets the ipv4 address type.
     */
    @JvmName("peodncwtctcgvyos")
    public fun ipv4AddressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4AddressType = mapped
    }

    /**
     * @param value Gets or sets the ipv4 address type.
     */
    @JvmName("vlrldnjyxighoncv")
    public fun ipv4AddressType(`value`: AllocationMethod) {
        val toBeMapped = Either.ofRight<String, AllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4AddressType = mapped
    }

    /**
     * @param value Gets or sets the ipv6 address type.
     */
    @JvmName("cikkmqohfugvxvau")
    public suspend fun ipv6AddressType(`value`: Either<String, AllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressType = mapped
    }

    /**
     * @param value Gets or sets the ipv6 address type.
     */
    @JvmName("svguelpmphpwcshk")
    public fun ipv6AddressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6AddressType = mapped
    }

    /**
     * @param value Gets or sets the ipv6 address type.
     */
    @JvmName("tbputbcivjjgqeet")
    public fun ipv6AddressType(`value`: AllocationMethod) {
        val toBeMapped = Either.ofRight<String, AllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6AddressType = mapped
    }

    /**
     * @param value Gets or sets the nic MAC address.
     */
    @JvmName("gwehqdufjeodniaf")
    public suspend fun macAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.macAddress = mapped
    }

    /**
     * @param value Gets or sets the mac address type.
     */
    @JvmName("ystilymvvwjefitg")
    public suspend fun macAddressType(`value`: Either<String, AllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.macAddressType = mapped
    }

    /**
     * @param value Gets or sets the mac address type.
     */
    @JvmName("ivbxdjjppdqcjlqn")
    public fun macAddressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.macAddressType = mapped
    }

    /**
     * @param value Gets or sets the mac address type.
     */
    @JvmName("qhvuydutxnyagblb")
    public fun macAddressType(`value`: AllocationMethod) {
        val toBeMapped = Either.ofRight<String, AllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.macAddressType = mapped
    }

    /**
     * @param value Gets or sets the name of the network interface.
     */
    @JvmName("egqoonwhgfibuxwu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the nic id.
     */
    @JvmName("oygsaqnbibqcwvix")
    public suspend fun nicId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nicId = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork resource to connect the nic.
     */
    @JvmName("yttcyeardekbfscg")
    public suspend fun virtualNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkId = mapped
    }

    internal fun build(): NetworkInterfacesArgs = NetworkInterfacesArgs(
        ipv4AddressType = ipv4AddressType,
        ipv6AddressType = ipv6AddressType,
        macAddress = macAddress,
        macAddressType = macAddressType,
        name = name,
        nicId = nicId,
        virtualNetworkId = virtualNetworkId,
    )
}
