@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.StorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the resource properties.
 * @property disks Gets or sets the list of virtual disks associated with the virtual machine.
 */
public data class StorageProfileArgs(
    public val disks: Output<List<VirtualDiskArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.StorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.StorageProfileArgs =
        com.pulumi.azurenative.scvmm.inputs.StorageProfileArgs.builder()
            .disks(
                disks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageProfileArgs].
 */
@PulumiTagMarker
public class StorageProfileArgsBuilder internal constructor() {
    private var disks: Output<List<VirtualDiskArgs>>? = null

    /**
     * @param value Gets or sets the list of virtual disks associated with the virtual machine.
     */
    @JvmName("vabeyhuuljwtkirk")
    public suspend fun disks(`value`: Output<List<VirtualDiskArgs>>) {
        this.disks = value
    }

    @JvmName("nthelvqegvffyqmh")
    public suspend fun disks(vararg values: Output<VirtualDiskArgs>) {
        this.disks = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of virtual disks associated with the virtual machine.
     */
    @JvmName("rwlnsjwwlcdqdcuh")
    public suspend fun disks(values: List<Output<VirtualDiskArgs>>) {
        this.disks = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of virtual disks associated with the virtual machine.
     */
    @JvmName("lbqijbmsgixhxtrf")
    public suspend fun disks(`value`: List<VirtualDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    /**
     * @param argument Gets or sets the list of virtual disks associated with the virtual machine.
     */
    @JvmName("kxbtmrxiudbkalfo")
    public suspend fun disks(argument: List<suspend VirtualDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VirtualDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument Gets or sets the list of virtual disks associated with the virtual machine.
     */
    @JvmName("cfabxursmqyyrcqa")
    public suspend fun disks(vararg argument: suspend VirtualDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VirtualDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param argument Gets or sets the list of virtual disks associated with the virtual machine.
     */
    @JvmName("qexfgkkhgilymjgf")
    public suspend fun disks(argument: suspend VirtualDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.disks = mapped
    }

    /**
     * @param values Gets or sets the list of virtual disks associated with the virtual machine.
     */
    @JvmName("dcqxrovuhipiajhi")
    public suspend fun disks(vararg values: VirtualDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disks = mapped
    }

    internal fun build(): StorageProfileArgs = StorageProfileArgs(
        disks = disks,
    )
}
