@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.StorageQoSPolicyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The StorageQoSPolicyDetails definition.
 * @property id The ID of the QoS policy.
 * @property name The name of the policy.
 */
public data class StorageQoSPolicyDetailsArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.StorageQoSPolicyDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.StorageQoSPolicyDetailsArgs =
        com.pulumi.azurenative.scvmm.inputs.StorageQoSPolicyDetailsArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageQoSPolicyDetailsArgs].
 */
@PulumiTagMarker
public class StorageQoSPolicyDetailsArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The ID of the QoS policy.
     */
    @JvmName("rwbllsormhkhnmve")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("eyjhfgjrosqdvkcx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the QoS policy.
     */
    @JvmName("seepduxvjotifapu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("faqgphenqampskmw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): StorageQoSPolicyDetailsArgs = StorageQoSPolicyDetailsArgs(
        id = id,
        name = name,
    )
}
