@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.VirtualMachinePropertiesAvailabilitySetsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Availability Set model
 * @property id Gets the ARM Id of the microsoft.scvmm/availabilitySets resource.
 * @property name Gets or sets the name of the availability set.
 */
public data class VirtualMachinePropertiesAvailabilitySetsArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.VirtualMachinePropertiesAvailabilitySetsArgs> {
    override fun toJava():
        com.pulumi.azurenative.scvmm.inputs.VirtualMachinePropertiesAvailabilitySetsArgs =
        com.pulumi.azurenative.scvmm.inputs.VirtualMachinePropertiesAvailabilitySetsArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachinePropertiesAvailabilitySetsArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesAvailabilitySetsArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Gets the ARM Id of the microsoft.scvmm/availabilitySets resource.
     */
    @JvmName("ftdspvrpdoesdpns")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Gets or sets the name of the availability set.
     */
    @JvmName("ftbqxpxbaftryvqc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets the ARM Id of the microsoft.scvmm/availabilitySets resource.
     */
    @JvmName("yvunvaawxkwxeoyv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Gets or sets the name of the availability set.
     */
    @JvmName("dwvgihnqrghihbai")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): VirtualMachinePropertiesAvailabilitySetsArgs =
        VirtualMachinePropertiesAvailabilitySetsArgs(
            id = id,
            name = name,
        )
}
