@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Define the virtualMachineInstance.
 * @property availabilitySets Availability Sets in vm.
 * @property extendedLocation Gets or sets the extended location.
 * @property hardwareProfile Hardware properties.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property infrastructureProfile Gets the infrastructure profile.
 * @property name The name of the resource
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property powerState Gets the power state of the virtual machine.
 * @property provisioningState Gets or sets the provisioning state.
 * @property storageProfile Storage properties.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetVirtualMachineInstanceResult(
    public val availabilitySets: List<VirtualMachineInstancePropertiesResponseAvailabilitySets>? =
        null,
    public val extendedLocation: ExtendedLocationResponse,
    public val hardwareProfile: HardwareProfileResponse? = null,
    public val id: String,
    public val infrastructureProfile: InfrastructureProfileResponse? = null,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val osProfile: OsProfileForVMInstanceResponse? = null,
    public val powerState: String,
    public val provisioningState: String,
    public val storageProfile: StorageProfileResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.GetVirtualMachineInstanceResult):
            GetVirtualMachineInstanceResult = GetVirtualMachineInstanceResult(
            availabilitySets = javaType.availabilitySets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.VirtualMachineInstancePropertiesResponseAvailabilitySets.Companion.toKotlin(args0)
                })
            }),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            infrastructureProfile = javaType.infrastructureProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.InfrastructureProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.OsProfileForVMInstanceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            powerState = javaType.powerState(),
            provisioningState = javaType.provisioningState(),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
