@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed service identity.
 * @property principalId The principal id of managed service identity.
 * @property tenantId The tenant of managed service identity.
 * @property type The type of managed service identity.
 */
public data class IdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.IdentityResponse):
            IdentityResponse = IdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
