@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the vmmServer infrastructure specific settings for the virtual machine instance.
 * @property biosGuid Gets or sets the bios guid for the vm.
 * @property checkpointType Type of checkpoint supported for the vm.
 * @property checkpoints Checkpoints in the vm.
 * @property cloudId ARM Id of the cloud resource to use for deploying the vm.
 * @property generation Gets or sets the generation for the vm.
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property lastRestoredVMCheckpoint Last restored checkpoint in the vm.
 * @property templateId ARM Id of the template resource to use for deploying the vm.
 * @property uuid Unique ID of the virtual machine.
 * @property vmName VMName is the name of VM on the SCVMM server.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class InfrastructureProfileResponse(
    public val biosGuid: String? = null,
    public val checkpointType: String? = null,
    public val checkpoints: List<CheckpointResponse>? = null,
    public val cloudId: String? = null,
    public val generation: Int? = null,
    public val inventoryItemId: String? = null,
    public val lastRestoredVMCheckpoint: CheckpointResponse,
    public val templateId: String? = null,
    public val uuid: String? = null,
    public val vmName: String? = null,
    public val vmmServerId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.InfrastructureProfileResponse):
            InfrastructureProfileResponse = InfrastructureProfileResponse(
            biosGuid = javaType.biosGuid().map({ args0 -> args0 }).orElse(null),
            checkpointType = javaType.checkpointType().map({ args0 -> args0 }).orElse(null),
            checkpoints = javaType.checkpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scvmm.kotlin.outputs.CheckpointResponse.Companion.toKotlin(args0)
                })
            }),
            cloudId = javaType.cloudId().map({ args0 -> args0 }).orElse(null),
            generation = javaType.generation().map({ args0 -> args0 }).orElse(null),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            lastRestoredVMCheckpoint = javaType.lastRestoredVMCheckpoint().let({ args0 ->
                com.pulumi.azurenative.scvmm.kotlin.outputs.CheckpointResponse.Companion.toKotlin(args0)
            }),
            templateId = javaType.templateId().map({ args0 -> args0 }).orElse(null),
            uuid = javaType.uuid().map({ args0 -> args0 }).orElse(null),
            vmName = javaType.vmName().map({ args0 -> args0 }).orElse(null),
            vmmServerId = javaType.vmmServerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
