@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network Interface model
 * @property displayName Gets the display name of the network interface as shown in the vmmServer. This is the fallback label for a NIC when the name is not set.
 * @property ipv4AddressType Gets or sets the ipv4 address type.
 * @property ipv4Addresses Gets or sets the nic ipv4 addresses.
 * @property ipv6AddressType Gets or sets the ipv6 address type.
 * @property ipv6Addresses Gets or sets the nic ipv6 addresses.
 * @property macAddress Gets or sets the nic MAC address.
 * @property macAddressType Gets or sets the mac address type.
 * @property name Gets or sets the name of the network interface.
 * @property networkName Gets or sets the name of the virtual network in vmmServer that the nic is connected to.
 * @property nicId Gets or sets the nic id.
 * @property virtualNetworkId Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork resource to connect the nic.
 */
public data class NetworkInterfacesResponse(
    public val displayName: String,
    public val ipv4AddressType: String? = null,
    public val ipv4Addresses: List<String>,
    public val ipv6AddressType: String? = null,
    public val ipv6Addresses: List<String>,
    public val macAddress: String? = null,
    public val macAddressType: String? = null,
    public val name: String? = null,
    public val networkName: String,
    public val nicId: String? = null,
    public val virtualNetworkId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scvmm.outputs.NetworkInterfacesResponse):
            NetworkInterfacesResponse = NetworkInterfacesResponse(
            displayName = javaType.displayName(),
            ipv4AddressType = javaType.ipv4AddressType().map({ args0 -> args0 }).orElse(null),
            ipv4Addresses = javaType.ipv4Addresses().map({ args0 -> args0 }),
            ipv6AddressType = javaType.ipv6AddressType().map({ args0 -> args0 }).orElse(null),
            ipv6Addresses = javaType.ipv6Addresses().map({ args0 -> args0 }),
            macAddress = javaType.macAddress().map({ args0 -> args0 }).orElse(null),
            macAddressType = javaType.macAddressType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkName = javaType.networkName(),
            nicId = javaType.nicId().map({ args0 -> args0 }).orElse(null),
            virtualNetworkId = javaType.virtualNetworkId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
