@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin

import com.pulumi.azurenative.search.SharedPrivateLinkResourceArgs.builder
import com.pulumi.azurenative.search.kotlin.inputs.SharedPrivateLinkResourcePropertiesArgs
import com.pulumi.azurenative.search.kotlin.inputs.SharedPrivateLinkResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2023-11-01.
 * ## Example Usage
 * ### SharedPrivateLinkResourceCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sharedPrivateLinkResource = new AzureNative.Search.SharedPrivateLinkResource("sharedPrivateLinkResource", new()
 *     {
 *         Properties = new AzureNative.Search.Inputs.SharedPrivateLinkResourcePropertiesArgs
 *         {
 *             GroupId = "blob",
 *             PrivateLinkResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storageAccountName",
 *             RequestMessage = "please approve",
 *         },
 *         ResourceGroupName = "rg1",
 *         SearchServiceName = "mysearchservice",
 *         SharedPrivateLinkResourceName = "testResource",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/search/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := search.NewSharedPrivateLinkResource(ctx, "sharedPrivateLinkResource", &search.SharedPrivateLinkResourceArgs{
 * 			Properties: &search.SharedPrivateLinkResourcePropertiesArgs{
 * 				GroupId:               pulumi.String("blob"),
 * 				PrivateLinkResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storageAccountName"),
 * 				RequestMessage:        pulumi.String("please approve"),
 * 			},
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			SearchServiceName:             pulumi.String("mysearchservice"),
 * 			SharedPrivateLinkResourceName: pulumi.String("testResource"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.search.SharedPrivateLinkResource;
 * import com.pulumi.azurenative.search.SharedPrivateLinkResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sharedPrivateLinkResource = new SharedPrivateLinkResource("sharedPrivateLinkResource", SharedPrivateLinkResourceArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("groupId", "blob"),
 *                 Map.entry("privateLinkResourceId", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Storage/storageAccounts/storageAccountName"),
 *                 Map.entry("requestMessage", "please approve")
 *             ))
 *             .resourceGroupName("rg1")
 *             .searchServiceName("mysearchservice")
 *             .sharedPrivateLinkResourceName("testResource")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:search:SharedPrivateLinkResource testResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}
 * ```
 * @property properties Describes the properties of a Shared Private Link Resource managed by the Azure Cognitive Search service.
 * @property resourceGroupName The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property searchServiceName The name of the Azure Cognitive Search service associated with the specified resource group.
 * @property sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive Search service within the specified resource group.
 */
public data class SharedPrivateLinkResourceArgs(
    public val properties: Output<SharedPrivateLinkResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val searchServiceName: Output<String>? = null,
    public val sharedPrivateLinkResourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.SharedPrivateLinkResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.search.SharedPrivateLinkResourceArgs =
        com.pulumi.azurenative.search.SharedPrivateLinkResourceArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .searchServiceName(searchServiceName?.applyValue({ args0 -> args0 }))
            .sharedPrivateLinkResourceName(
                sharedPrivateLinkResourceName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [SharedPrivateLinkResourceArgs].
 */
@PulumiTagMarker
public class SharedPrivateLinkResourceArgsBuilder internal constructor() {
    private var properties: Output<SharedPrivateLinkResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var searchServiceName: Output<String>? = null

    private var sharedPrivateLinkResourceName: Output<String>? = null

    /**
     * @param value Describes the properties of a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @JvmName("txsqamoiidesuiln")
    public suspend fun properties(`value`: Output<SharedPrivateLinkResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kfuabvtdxkxyirtk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Cognitive Search service associated with the specified resource group.
     */
    @JvmName("ualpovwaotlaigxm")
    public suspend fun searchServiceName(`value`: Output<String>) {
        this.searchServiceName = value
    }

    /**
     * @param value The name of the shared private link resource managed by the Azure Cognitive Search service within the specified resource group.
     */
    @JvmName("estyhoydaebvytsk")
    public suspend fun sharedPrivateLinkResourceName(`value`: Output<String>) {
        this.sharedPrivateLinkResourceName = value
    }

    /**
     * @param value Describes the properties of a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @JvmName("fpfkwksfrjptgdvw")
    public suspend fun properties(`value`: SharedPrivateLinkResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Describes the properties of a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @JvmName("qwhodojjqfvuknnv")
    public suspend
    fun properties(argument: suspend SharedPrivateLinkResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SharedPrivateLinkResourcePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nhqbkfasogediphu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Cognitive Search service associated with the specified resource group.
     */
    @JvmName("bkrhasgwtqeatmns")
    public suspend fun searchServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchServiceName = mapped
    }

    /**
     * @param value The name of the shared private link resource managed by the Azure Cognitive Search service within the specified resource group.
     */
    @JvmName("mlepmtxgfxmwvnrs")
    public suspend fun sharedPrivateLinkResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedPrivateLinkResourceName = mapped
    }

    internal fun build(): SharedPrivateLinkResourceArgs = SharedPrivateLinkResourceArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        searchServiceName = searchServiceName,
        sharedPrivateLinkResourceName = sharedPrivateLinkResourceName,
    )
}
