@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status of the the private link service connection. Can be Pending, Approved, Rejected, or Disconnected.
 */
public enum class PrivateLinkServiceConnectionStatus(
    public val javaValue: com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus> {
    /**
     * The private endpoint connection has been created and is pending approval.
     */
    Pending(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus.Pending),

    /**
     * The private endpoint connection is approved and is ready for use.
     */
    Approved(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus.Approved),

    /**
     * The private endpoint connection has been rejected and cannot be used.
     */
    Rejected(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus.Rejected),

    /**
     * The private endpoint connection has been removed from the service.
     */
    Disconnected(com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus.Disconnected),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.search.enums.PrivateLinkServiceConnectionStatus):
            PrivateLinkServiceConnectionStatus =
            PrivateLinkServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
