@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The provisioning state of the shared private link resource. Can be Updating, Deleting, Failed, Succeeded or Incomplete.
 */
public enum class SharedPrivateLinkResourceProvisioningState(
    public val javaValue:
    com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState,
) :
    ConvertibleToJava<com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState> {
    Updating(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState.Deleting),
    Failed(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState.Failed),
    Succeeded(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState.Succeeded),
    Incomplete(com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState.Incomplete),
    ;

    override fun toJava():
        com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.search.enums.SharedPrivateLinkResourceProvisioningState):
            SharedPrivateLinkResourceProvisioningState =
            SharedPrivateLinkResourceProvisioningState.values().first { it.javaValue == javaType }
    }
}
