@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SKU of the search service. Valid values include: 'free': Shared service. 'basic': Dedicated service with up to 3 replicas. 'standard': Dedicated service with up to 12 partitions and 12 replicas. 'standard2': Similar to standard, but with more capacity per search unit. 'standard3': The largest Standard offering with up to 12 partitions and 12 replicas (or up to 3 partitions with more indexes if you also set the hostingMode property to 'highDensity'). 'storage_optimized_l1': Supports 1TB per partition, up to 12 partitions. 'storage_optimized_l2': Supports 2TB per partition, up to 12 partitions.'
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.search.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.search.enums.SkuName> {
    /**
     * Free tier, with no SLA guarantees and a subset of features offered to paid tiers.
     */
    Free(com.pulumi.azurenative.search.enums.SkuName.Free),

    /**
     * Paid tier dedicated service with up to 3 replicas.
     */
    Basic(com.pulumi.azurenative.search.enums.SkuName.Basic),

    /**
     * Paid tier dedicated service with up to 12 partitions and 12 replicas.
     */
    Standard(com.pulumi.azurenative.search.enums.SkuName.Standard),

    /**
     * Similar to 'standard', but with more capacity per search unit.
     */
    Standard2(com.pulumi.azurenative.search.enums.SkuName.Standard2),

    /**
     *  The largest Standard offering with up to 12 partitions and 12 replicas (or up to 3 partitions with more indexes if you also set the hostingMode property to 'highDensity').
     */
    Standard3(com.pulumi.azurenative.search.enums.SkuName.Standard3),

    /**
     * Paid tier dedicated service that supports 1TB per partition, up to 12 partitions.
     */
    StorageOptimizedL1(com.pulumi.azurenative.search.enums.SkuName.StorageOptimizedL1),

    /**
     * Paid tier dedicated service that supports 2TB per partition, up to 12 partitions.
     */
    StorageOptimizedL2(com.pulumi.azurenative.search.enums.SkuName.StorageOptimizedL2),
    ;

    override fun toJava(): com.pulumi.azurenative.search.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
