@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.NetworkRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network specific rules that determine how the Azure Cognitive Search service may be reached.
 * @property ipRules A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
 */
public data class NetworkRuleSetArgs(
    public val ipRules: Output<List<IpRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.NetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.NetworkRuleSetArgs =
        com.pulumi.azurenative.search.inputs.NetworkRuleSetArgs.builder()
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetArgsBuilder internal constructor() {
    private var ipRules: Output<List<IpRuleArgs>>? = null

    /**
     * @param value A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("nbynogqemoltmcys")
    public suspend fun ipRules(`value`: Output<List<IpRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("tfpfahtsthnogjjd")
    public suspend fun ipRules(vararg values: Output<IpRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("vsdkjnmdwqxtrneg")
    public suspend fun ipRules(values: List<Output<IpRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("xxhyderxeerhwrdn")
    public suspend fun ipRules(`value`: List<IpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("yvbkkajsokaykgqp")
    public suspend fun ipRules(argument: List<suspend IpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("fodnebehqdvwihsm")
    public suspend fun ipRules(vararg argument: suspend IpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("pqudcvvmusolwtqm")
    public suspend fun ipRules(argument: suspend IpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values A list of IP restriction rules that defines the inbound network(s) with allowing access to the search service endpoint. At the meantime, all other public IP networks are blocked by the firewall. These restriction rules are applied only when the 'publicNetworkAccess' of the search service is 'enabled'; otherwise, traffic over public interface is not allowed even with any public IP rules, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("cissgsvkhrlghniu")
    public suspend fun ipRules(vararg values: IpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    internal fun build(): NetworkRuleSetArgs = NetworkRuleSetArgs(
        ipRules = ipRules,
    )
}
