@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property properties Describes the properties of a Shared Private Link Resource managed by the Azure Cognitive Search service.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSharedPrivateLinkResourceResult(
    public val id: String,
    public val name: String,
    public val properties: SharedPrivateLinkResourcePropertiesResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.GetSharedPrivateLinkResourceResult):
            GetSharedPrivateLinkResourceResult = GetSharedPrivateLinkResourceResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.search.kotlin.outputs.SharedPrivateLinkResourcePropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
