@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an API key for a given Azure Cognitive Search service that has permissions for query operations only.
 * @property key The value of the query API key.
 * @property name The name of the query API key; may be empty.
 */
public data class QueryKeyResponse(
    public val key: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.QueryKeyResponse):
            QueryKeyResponse = QueryKeyResponse(
            key = javaType.key(),
            name = javaType.name(),
        )
    }
}
