@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AdvancedThreatProtection].
 */
@PulumiTagMarker
public class AdvancedThreatProtectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdvancedThreatProtectionArgs = AdvancedThreatProtectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdvancedThreatProtectionArgsBuilder.() -> Unit) {
        val builder = AdvancedThreatProtectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AdvancedThreatProtection {
        val builtJavaResource =
            com.pulumi.azurenative.security.AdvancedThreatProtection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AdvancedThreatProtection(builtJavaResource)
    }
}

/**
 * The Advanced Threat Protection resource.
 * Azure REST API version: 2019-01-01. Prior API version in Azure Native 1.x: 2019-01-01.
 * ## Example Usage
 * ### Creates or updates the Advanced Threat Protection settings on a specified resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var advancedThreatProtection = new AzureNative.Security.AdvancedThreatProtection("advancedThreatProtection", new()
 *     {
 *         IsEnabled = true,
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount",
 *         SettingName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAdvancedThreatProtection(ctx, "advancedThreatProtection", &security.AdvancedThreatProtectionArgs{
 * 			IsEnabled:   pulumi.Bool(true),
 * 			ResourceId:  pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount"),
 * 			SettingName: pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AdvancedThreatProtection;
 * import com.pulumi.azurenative.security.AdvancedThreatProtectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var advancedThreatProtection = new AdvancedThreatProtection("advancedThreatProtection", AdvancedThreatProtectionArgs.builder()
 *             .isEnabled(true)
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount")
 *             .settingName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AdvancedThreatProtection current /{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}
 * ```
 */
public class AdvancedThreatProtection internal constructor(
    override val javaResource: com.pulumi.azurenative.security.AdvancedThreatProtection,
) : KotlinCustomResource(javaResource, AdvancedThreatProtectionMapper) {
    /**
     * Indicates whether Advanced Threat Protection is enabled.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AdvancedThreatProtectionMapper : ResourceMapper<AdvancedThreatProtection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.AdvancedThreatProtection::class == javaResource::class

    override fun map(javaResource: Resource): AdvancedThreatProtection =
        AdvancedThreatProtection(
            javaResource as
                com.pulumi.azurenative.security.AdvancedThreatProtection,
        )
}

/**
 * @see [AdvancedThreatProtection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AdvancedThreatProtection].
 */
public suspend fun advancedThreatProtection(
    name: String,
    block: suspend AdvancedThreatProtectionResourceBuilder.() -> Unit,
): AdvancedThreatProtection {
    val builder = AdvancedThreatProtectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AdvancedThreatProtection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun advancedThreatProtection(name: String): AdvancedThreatProtection {
    val builder = AdvancedThreatProtectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
