@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AlertsSuppressionRuleArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.RuleState
import com.pulumi.azurenative.security.kotlin.inputs.SuppressionAlertsScopeArgs
import com.pulumi.azurenative.security.kotlin.inputs.SuppressionAlertsScopeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the suppression rule
 * Azure REST API version: 2019-01-01-preview. Prior API version in Azure Native 1.x: 2019-01-01-preview.
 * ## Example Usage
 * ### Update or create suppression rule for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertsSuppressionRule = new AzureNative.Security.AlertsSuppressionRule("alertsSuppressionRule", new()
 *     {
 *         AlertType = "IpAnomaly",
 *         AlertsSuppressionRuleName = "dismissIpAnomalyAlerts",
 *         Comment = "Test VM",
 *         ExpirationDateUtc = "2019-12-01T19:50:47.083633Z",
 *         Reason = "FalsePositive",
 *         State = "Enabled",
 *         SuppressionAlertsScope = new AzureNative.Security.Inputs.SuppressionAlertsScopeArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Security.Inputs.ScopeElementArgs
 *                 {
 *                     Field = "entities.ip.address",
 *                 },
 *                 new AzureNative.Security.Inputs.ScopeElementArgs
 *                 {
 *                     Field = "entities.process.commandline",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAlertsSuppressionRule(ctx, "alertsSuppressionRule", &security.AlertsSuppressionRuleArgs{
 * 			AlertType:                 pulumi.String("IpAnomaly"),
 * 			AlertsSuppressionRuleName: pulumi.String("dismissIpAnomalyAlerts"),
 * 			Comment:                   pulumi.String("Test VM"),
 * 			ExpirationDateUtc:         pulumi.String("2019-12-01T19:50:47.083633Z"),
 * 			Reason:                    pulumi.String("FalsePositive"),
 * 			State:                     pulumi.String("Enabled"),
 * 			SuppressionAlertsScope: security.SuppressionAlertsScopeResponse{
 * 				AllOf: security.ScopeElementArray{
 * 					&security.ScopeElementArgs{
 * 						Field: pulumi.String("entities.ip.address"),
 * 					},
 * 					&security.ScopeElementArgs{
 * 						Field: pulumi.String("entities.process.commandline"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AlertsSuppressionRule;
 * import com.pulumi.azurenative.security.AlertsSuppressionRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertsSuppressionRule = new AlertsSuppressionRule("alertsSuppressionRule", AlertsSuppressionRuleArgs.builder()
 *             .alertType("IpAnomaly")
 *             .alertsSuppressionRuleName("dismissIpAnomalyAlerts")
 *             .comment("Test VM")
 *             .expirationDateUtc("2019-12-01T19:50:47.083633Z")
 *             .reason("FalsePositive")
 *             .state("Enabled")
 *             .suppressionAlertsScope(Map.of("allOf",
 *                 Map.of("field", "entities.ip.address"),
 *                 Map.of("field", "entities.process.commandline")))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AlertsSuppressionRule dismissIpAnomalyAlerts /subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}
 * ```
 * @property alertType Type of the alert to automatically suppress. For all alert types, use '*'
 * @property alertsSuppressionRuleName The unique name of the suppression alert rule
 * @property comment Any comment regarding the rule
 * @property expirationDateUtc Expiration date of the rule, if value is not provided or provided as null there will no expiration at all
 * @property reason The reason for dismissing the alert
 * @property state Possible states of the rule
 * @property suppressionAlertsScope The suppression conditions
 */
public data class AlertsSuppressionRuleArgs(
    public val alertType: Output<String>? = null,
    public val alertsSuppressionRuleName: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val expirationDateUtc: Output<String>? = null,
    public val reason: Output<String>? = null,
    public val state: Output<Either<String, RuleState>>? = null,
    public val suppressionAlertsScope: Output<SuppressionAlertsScopeArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AlertsSuppressionRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AlertsSuppressionRuleArgs =
        com.pulumi.azurenative.security.AlertsSuppressionRuleArgs.builder()
            .alertType(alertType?.applyValue({ args0 -> args0 }))
            .alertsSuppressionRuleName(alertsSuppressionRuleName?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .expirationDateUtc(expirationDateUtc?.applyValue({ args0 -> args0 }))
            .reason(reason?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .suppressionAlertsScope(
                suppressionAlertsScope?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AlertsSuppressionRuleArgs].
 */
@PulumiTagMarker
public class AlertsSuppressionRuleArgsBuilder internal constructor() {
    private var alertType: Output<String>? = null

    private var alertsSuppressionRuleName: Output<String>? = null

    private var comment: Output<String>? = null

    private var expirationDateUtc: Output<String>? = null

    private var reason: Output<String>? = null

    private var state: Output<Either<String, RuleState>>? = null

    private var suppressionAlertsScope: Output<SuppressionAlertsScopeArgs>? = null

    /**
     * @param value Type of the alert to automatically suppress. For all alert types, use '*'
     */
    @JvmName("navfiwqkiffuvgti")
    public suspend fun alertType(`value`: Output<String>) {
        this.alertType = value
    }

    /**
     * @param value The unique name of the suppression alert rule
     */
    @JvmName("olgtwtfaqrsntxyl")
    public suspend fun alertsSuppressionRuleName(`value`: Output<String>) {
        this.alertsSuppressionRuleName = value
    }

    /**
     * @param value Any comment regarding the rule
     */
    @JvmName("cexysmqvoscjyipv")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Expiration date of the rule, if value is not provided or provided as null there will no expiration at all
     */
    @JvmName("tcmwyijkohripmcf")
    public suspend fun expirationDateUtc(`value`: Output<String>) {
        this.expirationDateUtc = value
    }

    /**
     * @param value The reason for dismissing the alert
     */
    @JvmName("dnmbgryupifgpdix")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value Possible states of the rule
     */
    @JvmName("jcsphaeqscgblhku")
    public suspend fun state(`value`: Output<Either<String, RuleState>>) {
        this.state = value
    }

    /**
     * @param value The suppression conditions
     */
    @JvmName("borbosxfgkvbqfom")
    public suspend fun suppressionAlertsScope(`value`: Output<SuppressionAlertsScopeArgs>) {
        this.suppressionAlertsScope = value
    }

    /**
     * @param value Type of the alert to automatically suppress. For all alert types, use '*'
     */
    @JvmName("lnsxmuniqdekatjn")
    public suspend fun alertType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertType = mapped
    }

    /**
     * @param value The unique name of the suppression alert rule
     */
    @JvmName("kwxlsfakcygfnuet")
    public suspend fun alertsSuppressionRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertsSuppressionRuleName = mapped
    }

    /**
     * @param value Any comment regarding the rule
     */
    @JvmName("yeaecnsailhxcvju")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Expiration date of the rule, if value is not provided or provided as null there will no expiration at all
     */
    @JvmName("dubfwiimffrvermy")
    public suspend fun expirationDateUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDateUtc = mapped
    }

    /**
     * @param value The reason for dismissing the alert
     */
    @JvmName("twgmnwkdluktcnub")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    /**
     * @param value Possible states of the rule
     */
    @JvmName("fpkwgqcbavwowmkn")
    public suspend fun state(`value`: Either<String, RuleState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Possible states of the rule
     */
    @JvmName("lveutbkaxgigmssj")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Possible states of the rule
     */
    @JvmName("ojkoaqagjvoxoskf")
    public fun state(`value`: RuleState) {
        val toBeMapped = Either.ofRight<String, RuleState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The suppression conditions
     */
    @JvmName("lsarwxuxskvltfna")
    public suspend fun suppressionAlertsScope(`value`: SuppressionAlertsScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressionAlertsScope = mapped
    }

    /**
     * @param argument The suppression conditions
     */
    @JvmName("akdaxbkvvumyxyww")
    public suspend
    fun suppressionAlertsScope(argument: suspend SuppressionAlertsScopeArgsBuilder.() -> Unit) {
        val toBeMapped = SuppressionAlertsScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.suppressionAlertsScope = mapped
    }

    internal fun build(): AlertsSuppressionRuleArgs = AlertsSuppressionRuleArgs(
        alertType = alertType,
        alertsSuppressionRuleName = alertsSuppressionRuleName,
        comment = comment,
        expirationDateUtc = expirationDateUtc,
        reason = reason,
        state = state,
        suppressionAlertsScope = suppressionAlertsScope,
    )
}
