@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AssessmentArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.AssessmentStatusArgs
import com.pulumi.azurenative.security.kotlin.inputs.AssessmentStatusArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentMetadataPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentMetadataPropertiesArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentPartnerDataArgs
import com.pulumi.azurenative.security.kotlin.inputs.SecurityAssessmentPartnerDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Security assessment on a resource - response format
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * Other available API versions: 2020-01-01.
 * ## Example Usage
 * ### Create security recommendation task on a resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessment = new AzureNative.Security.Assessment("assessment", new()
 *     {
 *         AssessmentName = "8bb8be0a-6010-4789-812f-e4d661c4ed0e",
 *         ResourceDetails = new AzureNative.Security.Inputs.AzureResourceDetailsArgs
 *         {
 *             Source = "Azure",
 *         },
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.Compute/virtualMachineScaleSets/vmss2",
 *         Status = new AzureNative.Security.Inputs.AssessmentStatusArgs
 *         {
 *             Code = "Healthy",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssessment(ctx, "assessment", &security.AssessmentArgs{
 * 			AssessmentName: pulumi.String("8bb8be0a-6010-4789-812f-e4d661c4ed0e"),
 * 			ResourceDetails: security.AzureResourceDetails{
 * 				Source: "Azure",
 * 			},
 * 			ResourceId: pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.Compute/virtualMachineScaleSets/vmss2"),
 * 			Status: &security.AssessmentStatusArgs{
 * 				Code: pulumi.String("Healthy"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Assessment;
 * import com.pulumi.azurenative.security.AssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessment = new Assessment("assessment", AssessmentArgs.builder()
 *             .assessmentName("8bb8be0a-6010-4789-812f-e4d661c4ed0e")
 *             .resourceDetails(Map.of("source", "Azure"))
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.Compute/virtualMachineScaleSets/vmss2")
 *             .status(Map.of("code", "Healthy"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Assessment 8bb8be0a-6010-4789-812f-e4d661c4ed0e /{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}
 * ```
 * @property additionalData Additional data regarding the assessment
 * @property assessmentName The Assessment Key - Unique key for the assessment type
 * @property metadata Describes properties of an assessment metadata.
 * @property partnersData Data regarding 3rd party partner integration
 * @property resourceDetails Details of the resource that was assessed
 * @property resourceId The identifier of the resource.
 * @property status The result of the assessment
 */
public data class AssessmentArgs(
    public val additionalData: Output<Map<String, String>>? = null,
    public val assessmentName: Output<String>? = null,
    public val metadata: Output<SecurityAssessmentMetadataPropertiesArgs>? = null,
    public val partnersData: Output<SecurityAssessmentPartnerDataArgs>? = null,
    public val resourceDetails: Output<Any>? = null,
    public val resourceId: Output<String>? = null,
    public val status: Output<AssessmentStatusArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AssessmentArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AssessmentArgs =
        com.pulumi.azurenative.security.AssessmentArgs.builder()
            .additionalData(
                additionalData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .partnersData(partnersData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceDetails(resourceDetails?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AssessmentArgs].
 */
@PulumiTagMarker
public class AssessmentArgsBuilder internal constructor() {
    private var additionalData: Output<Map<String, String>>? = null

    private var assessmentName: Output<String>? = null

    private var metadata: Output<SecurityAssessmentMetadataPropertiesArgs>? = null

    private var partnersData: Output<SecurityAssessmentPartnerDataArgs>? = null

    private var resourceDetails: Output<Any>? = null

    private var resourceId: Output<String>? = null

    private var status: Output<AssessmentStatusArgs>? = null

    /**
     * @param value Additional data regarding the assessment
     */
    @JvmName("ydastshrapdtkjex")
    public suspend fun additionalData(`value`: Output<Map<String, String>>) {
        this.additionalData = value
    }

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("slkpdacmtefvggvu")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value Describes properties of an assessment metadata.
     */
    @JvmName("ltqdadrbtiiockvr")
    public suspend fun metadata(`value`: Output<SecurityAssessmentMetadataPropertiesArgs>) {
        this.metadata = value
    }

    /**
     * @param value Data regarding 3rd party partner integration
     */
    @JvmName("enbwpkcirbeshamx")
    public suspend fun partnersData(`value`: Output<SecurityAssessmentPartnerDataArgs>) {
        this.partnersData = value
    }

    /**
     * @param value Details of the resource that was assessed
     */
    @JvmName("euejmdqytlqcmrbx")
    public suspend fun resourceDetails(`value`: Output<Any>) {
        this.resourceDetails = value
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("otgikoyxnogmxagp")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The result of the assessment
     */
    @JvmName("shcujlwhnrkbpykv")
    public suspend fun status(`value`: Output<AssessmentStatusArgs>) {
        this.status = value
    }

    /**
     * @param value Additional data regarding the assessment
     */
    @JvmName("wvovfhgugtqfccxm")
    public suspend fun additionalData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalData = mapped
    }

    /**
     * @param values Additional data regarding the assessment
     */
    @JvmName("blexsosoofbvcvtj")
    public fun additionalData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalData = mapped
    }

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("pjuhirsqmpjqkfgr")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value Describes properties of an assessment metadata.
     */
    @JvmName("ooyedkcopfqofsaw")
    public suspend fun metadata(`value`: SecurityAssessmentMetadataPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Describes properties of an assessment metadata.
     */
    @JvmName("rkmrsfkxuemftnqe")
    public suspend
    fun metadata(argument: suspend SecurityAssessmentMetadataPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityAssessmentMetadataPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param value Data regarding 3rd party partner integration
     */
    @JvmName("orljnledqdkswsrt")
    public suspend fun partnersData(`value`: SecurityAssessmentPartnerDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnersData = mapped
    }

    /**
     * @param argument Data regarding 3rd party partner integration
     */
    @JvmName("cveopiivqhfbihnj")
    public suspend
    fun partnersData(argument: suspend SecurityAssessmentPartnerDataArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityAssessmentPartnerDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partnersData = mapped
    }

    /**
     * @param value Details of the resource that was assessed
     */
    @JvmName("svcgmdnoquhhsdrl")
    public suspend fun resourceDetails(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceDetails = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("helhwhointdihpab")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The result of the assessment
     */
    @JvmName("yhflhxbownorerpb")
    public suspend fun status(`value`: AssessmentStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param argument The result of the assessment
     */
    @JvmName("lhdnaamymmsxogkh")
    public suspend fun status(argument: suspend AssessmentStatusArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.status = mapped
    }

    internal fun build(): AssessmentArgs = AssessmentArgs(
        additionalData = additionalData,
        assessmentName = assessmentName,
        metadata = metadata,
        partnersData = partnersData,
        resourceDetails = resourceDetails,
        resourceId = resourceId,
        status = status,
    )
}
