@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AssessmentsMetadataSubscriptionArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.AssessmentType
import com.pulumi.azurenative.security.kotlin.enums.Categories
import com.pulumi.azurenative.security.kotlin.enums.ImplementationEffort
import com.pulumi.azurenative.security.kotlin.enums.Severity
import com.pulumi.azurenative.security.kotlin.enums.Threats
import com.pulumi.azurenative.security.kotlin.enums.UserImpact
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Security assessment metadata
 * Azure REST API version: 2019-01-01-preview.
 * ## Example Usage
 * ### Create security assessment metadata for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessmentsMetadataSubscription = new AzureNative.Security.AssessmentsMetadataSubscription("assessmentsMetadataSubscription", new()
 *     {
 *         AssessmentMetadataName = "ca039e75-a276-4175-aebc-bcd41e4b14b7",
 *         AssessmentType = "CustomerManaged",
 *         Categories = new[]
 *         {
 *             "Compute",
 *         },
 *         Description = "Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities.",
 *         DisplayName = "Install endpoint protection solution on virtual machine scale sets",
 *         ImplementationEffort = "Low",
 *         RemediationDescription = "To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>",
 *         Severity = "Medium",
 *         Threats = new[]
 *         {
 *             "dataExfiltration",
 *             "dataSpillage",
 *             "maliciousInsider",
 *         },
 *         UserImpact = "Low",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssessmentsMetadataSubscription(ctx, "assessmentsMetadataSubscription", &security.AssessmentsMetadataSubscriptionArgs{
 * 			AssessmentMetadataName: pulumi.String("ca039e75-a276-4175-aebc-bcd41e4b14b7"),
 * 			AssessmentType:         pulumi.String("CustomerManaged"),
 * 			Categories: pulumi.StringArray{
 * 				pulumi.String("Compute"),
 * 			},
 * 			Description:            pulumi.String("Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities."),
 * 			DisplayName:            pulumi.String("Install endpoint protection solution on virtual machine scale sets"),
 * 			ImplementationEffort:   pulumi.String("Low"),
 * 			RemediationDescription: pulumi.String("To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>"),
 * 			Severity:               pulumi.String("Medium"),
 * 			Threats: pulumi.StringArray{
 * 				pulumi.String("dataExfiltration"),
 * 				pulumi.String("dataSpillage"),
 * 				pulumi.String("maliciousInsider"),
 * 			},
 * 			UserImpact: pulumi.String("Low"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AssessmentsMetadataSubscription;
 * import com.pulumi.azurenative.security.AssessmentsMetadataSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessmentsMetadataSubscription = new AssessmentsMetadataSubscription("assessmentsMetadataSubscription", AssessmentsMetadataSubscriptionArgs.builder()
 *             .assessmentMetadataName("ca039e75-a276-4175-aebc-bcd41e4b14b7")
 *             .assessmentType("CustomerManaged")
 *             .categories("Compute")
 *             .description("Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities.")
 *             .displayName("Install endpoint protection solution on virtual machine scale sets")
 *             .implementationEffort("Low")
 *             .remediationDescription("To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>")
 *             .severity("Medium")
 *             .threats(
 *                 "dataExfiltration",
 *                 "dataSpillage",
 *                 "maliciousInsider")
 *             .userImpact("Low")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AssessmentsMetadataSubscription ca039e75-a276-4175-aebc-bcd41e4b14b7 /subscriptions/{subscriptionId}/providers/Microsoft.Security/assessmentMetadata/{assessmentMetadataName}
 * ```
 * @property assessmentMetadataName The Assessment Key - Unique key for the assessment type
 * @property assessmentType BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
 * @property categories
 * @property description Human readable description of the assessment
 * @property displayName User friendly display name of the assessment
 * @property implementationEffort The implementation effort required to remediate this assessment
 * @property preview True if this assessment is in preview release status
 * @property remediationDescription Human readable description of what you should do to mitigate this security issue
 * @property severity The severity level of the assessment
 * @property threats
 * @property userImpact The user impact of the assessment
 */
public data class AssessmentsMetadataSubscriptionArgs(
    public val assessmentMetadataName: Output<String>? = null,
    public val assessmentType: Output<Either<String, AssessmentType>>? = null,
    public val categories: Output<List<Either<String, Categories>>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val implementationEffort: Output<Either<String, ImplementationEffort>>? = null,
    public val preview: Output<Boolean>? = null,
    public val remediationDescription: Output<String>? = null,
    public val severity: Output<Either<String, Severity>>? = null,
    public val threats: Output<List<Either<String, Threats>>>? = null,
    public val userImpact: Output<Either<String, UserImpact>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AssessmentsMetadataSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AssessmentsMetadataSubscriptionArgs =
        com.pulumi.azurenative.security.AssessmentsMetadataSubscriptionArgs.builder()
            .assessmentMetadataName(assessmentMetadataName?.applyValue({ args0 -> args0 }))
            .assessmentType(
                assessmentType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .categories(
                categories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .implementationEffort(
                implementationEffort?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .preview(preview?.applyValue({ args0 -> args0 }))
            .remediationDescription(remediationDescription?.applyValue({ args0 -> args0 }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threats(
                threats?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .userImpact(
                userImpact?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AssessmentsMetadataSubscriptionArgs].
 */
@PulumiTagMarker
public class AssessmentsMetadataSubscriptionArgsBuilder internal constructor() {
    private var assessmentMetadataName: Output<String>? = null

    private var assessmentType: Output<Either<String, AssessmentType>>? = null

    private var categories: Output<List<Either<String, Categories>>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var implementationEffort: Output<Either<String, ImplementationEffort>>? = null

    private var preview: Output<Boolean>? = null

    private var remediationDescription: Output<String>? = null

    private var severity: Output<Either<String, Severity>>? = null

    private var threats: Output<List<Either<String, Threats>>>? = null

    private var userImpact: Output<Either<String, UserImpact>>? = null

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("obvpnouqlorqveut")
    public suspend fun assessmentMetadataName(`value`: Output<String>) {
        this.assessmentMetadataName = value
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("mluucfqyquwkkjsu")
    public suspend fun assessmentType(`value`: Output<Either<String, AssessmentType>>) {
        this.assessmentType = value
    }

    /**
     * @param value
     */
    @JvmName("qfpbbeuiatvpgnee")
    public suspend fun categories(`value`: Output<List<Either<String, Categories>>>) {
        this.categories = value
    }

    @JvmName("rtwcuaqncungvgam")
    public suspend fun categories(vararg values: Output<Either<String, Categories>>) {
        this.categories = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("eoabuamdnunytphn")
    public suspend fun categories(values: List<Output<Either<String, Categories>>>) {
        this.categories = Output.all(values)
    }

    /**
     * @param value Human readable description of the assessment
     */
    @JvmName("sbpihudxbtgjfvkb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value User friendly display name of the assessment
     */
    @JvmName("gakcpqktrtjoclra")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("etywelikvmwamyav")
    public suspend fun implementationEffort(`value`: Output<Either<String, ImplementationEffort>>) {
        this.implementationEffort = value
    }

    /**
     * @param value True if this assessment is in preview release status
     */
    @JvmName("isqhapyyrydiyohx")
    public suspend fun preview(`value`: Output<Boolean>) {
        this.preview = value
    }

    /**
     * @param value Human readable description of what you should do to mitigate this security issue
     */
    @JvmName("fcvgmbxexujmjygd")
    public suspend fun remediationDescription(`value`: Output<String>) {
        this.remediationDescription = value
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("wdcudgwuojvdngae")
    public suspend fun severity(`value`: Output<Either<String, Severity>>) {
        this.severity = value
    }

    /**
     * @param value
     */
    @JvmName("dhuqlinkhmolrolf")
    public suspend fun threats(`value`: Output<List<Either<String, Threats>>>) {
        this.threats = value
    }

    @JvmName("eiooqpanafuqatvs")
    public suspend fun threats(vararg values: Output<Either<String, Threats>>) {
        this.threats = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kktxkvrjlcppevgo")
    public suspend fun threats(values: List<Output<Either<String, Threats>>>) {
        this.threats = Output.all(values)
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("xktahjjsqyqmbhwa")
    public suspend fun userImpact(`value`: Output<Either<String, UserImpact>>) {
        this.userImpact = value
    }

    /**
     * @param value The Assessment Key - Unique key for the assessment type
     */
    @JvmName("oaulabshefkrmvjd")
    public suspend fun assessmentMetadataName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentMetadataName = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("cittbpaqnxoxklmm")
    public suspend fun assessmentType(`value`: Either<String, AssessmentType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("mwwixfeypthdlbyq")
    public fun assessmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("psooocuicdsuuuyu")
    public fun assessmentType(`value`: AssessmentType) {
        val toBeMapped = Either.ofRight<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value
     */
    @JvmName("umrocipxjiweaptc")
    public suspend fun categories(`value`: List<Either<String, Categories>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param values
     */
    @JvmName("jqpjlueewtgkmjkt")
    public suspend fun categories(vararg values: Either<String, Categories>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param value Human readable description of the assessment
     */
    @JvmName("nbjbxilbfleahqui")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value User friendly display name of the assessment
     */
    @JvmName("basfjbxlwfjfpmla")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("loxedyymhoetvdxu")
    public suspend fun implementationEffort(`value`: Either<String, ImplementationEffort>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("rlnevsmvvhteqceu")
    public fun implementationEffort(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImplementationEffort>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("qtlgrrqhgvmwfypq")
    public fun implementationEffort(`value`: ImplementationEffort) {
        val toBeMapped = Either.ofRight<String, ImplementationEffort>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value True if this assessment is in preview release status
     */
    @JvmName("lachhtljshqsvagw")
    public suspend fun preview(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preview = mapped
    }

    /**
     * @param value Human readable description of what you should do to mitigate this security issue
     */
    @JvmName("sxfmiynugwxtxvuy")
    public suspend fun remediationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationDescription = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("gymmgdforvqsgdui")
    public suspend fun severity(`value`: Either<String, Severity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("ykiijxeaqfdagnqf")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("lnxftbpgrpjhnaoh")
    public fun severity(`value`: Severity) {
        val toBeMapped = Either.ofRight<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value
     */
    @JvmName("ruhcrxsbydfjarnw")
    public suspend fun threats(`value`: List<Either<String, Threats>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threats = mapped
    }

    /**
     * @param values
     */
    @JvmName("lgitkaydnwfytykb")
    public suspend fun threats(vararg values: Either<String, Threats>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threats = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("hryeddrmtiimljmg")
    public suspend fun userImpact(`value`: Either<String, UserImpact>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("wddcvxnouedqyxwn")
    public fun userImpact(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UserImpact>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("kyckdqgbnctwcqiy")
    public fun userImpact(`value`: UserImpact) {
        val toBeMapped = Either.ofRight<String, UserImpact>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    internal fun build(): AssessmentsMetadataSubscriptionArgs = AssessmentsMetadataSubscriptionArgs(
        assessmentMetadataName = assessmentMetadataName,
        assessmentType = assessmentType,
        categories = categories,
        description = description,
        displayName = displayName,
        implementationEffort = implementationEffort,
        preview = preview,
        remediationDescription = remediationDescription,
        severity = severity,
        threats = threats,
        userImpact = userImpact,
    )
}
