@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.CustomAssessmentAutomationArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.SeverityEnum
import com.pulumi.azurenative.security.kotlin.enums.SupportedCloudEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom Assessment Automation
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * ## Example Usage
 * ### Create a Custom Assessment Automation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customAssessmentAutomation = new AzureNative.Security.CustomAssessmentAutomation("customAssessmentAutomation", new()
 *     {
 *         CompressedQuery = "DQAKAEkAYQBtAF8ARwByAG8AdQBwAA0ACgB8ACAAZQB4AHQAZQBuAGQAIABIAGUAYQBsAHQAaABTAHQAYQB0AHUAcwAgAD0AIABpAGYAZgAoAHQAbwBzAHQAcgBpAG4AZwAoAFIAZQBjAG8AcgBkAC4AVQBzAGUAcgBOAGEAbQBlACkAIABjAG8AbgB0AGEAaQBuAHMAIAAnAHUAcwBlAHIAJwAsACAAJwBVAE4ASABFAEEATABUAEgAWQAnACwAIAAnAEgARQBBAEwAVABIAFkAJwApAA0ACgA=",
 *         CustomAssessmentAutomationName = "MyCustomAssessmentAutomation",
 *         Description = "Data should be encrypted",
 *         DisplayName = "Password Policy",
 *         RemediationDescription = "Encrypt store by...",
 *         ResourceGroupName = "TestResourceGroup",
 *         Severity = "Medium",
 *         SupportedCloud = "AWS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewCustomAssessmentAutomation(ctx, "customAssessmentAutomation", &security.CustomAssessmentAutomationArgs{
 * 			CompressedQuery:                pulumi.String("DQAKAEkAYQBtAF8ARwByAG8AdQBwAA0ACgB8ACAAZQB4AHQAZQBuAGQAIABIAGUAYQBsAHQAaABTAHQAYQB0AHUAcwAgAD0AIABpAGYAZgAoAHQAbwBzAHQAcgBpAG4AZwAoAFIAZQBjAG8AcgBkAC4AVQBzAGUAcgBOAGEAbQBlACkAIABjAG8AbgB0AGEAaQBuAHMAIAAnAHUAcwBlAHIAJwAsACAAJwBVAE4ASABFAEEATABUAEgAWQAnACwAIAAnAEgARQBBAEwAVABIAFkAJwApAA0ACgA="),
 * 			CustomAssessmentAutomationName: pulumi.String("MyCustomAssessmentAutomation"),
 * 			Description:                    pulumi.String("Data should be encrypted"),
 * 			DisplayName:                    pulumi.String("Password Policy"),
 * 			RemediationDescription:         pulumi.String("Encrypt store by..."),
 * 			ResourceGroupName:              pulumi.String("TestResourceGroup"),
 * 			Severity:                       pulumi.String("Medium"),
 * 			SupportedCloud:                 pulumi.String("AWS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.CustomAssessmentAutomation;
 * import com.pulumi.azurenative.security.CustomAssessmentAutomationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customAssessmentAutomation = new CustomAssessmentAutomation("customAssessmentAutomation", CustomAssessmentAutomationArgs.builder()
 *             .compressedQuery("DQAKAEkAYQBtAF8ARwByAG8AdQBwAA0ACgB8ACAAZQB4AHQAZQBuAGQAIABIAGUAYQBsAHQAaABTAHQAYQB0AHUAcwAgAD0AIABpAGYAZgAoAHQAbwBzAHQAcgBpAG4AZwAoAFIAZQBjAG8AcgBkAC4AVQBzAGUAcgBOAGEAbQBlACkAIABjAG8AbgB0AGEAaQBuAHMAIAAnAHUAcwBlAHIAJwAsACAAJwBVAE4ASABFAEEATABUAEgAWQAnACwAIAAnAEgARQBBAEwAVABIAFkAJwApAA0ACgA=")
 *             .customAssessmentAutomationName("MyCustomAssessmentAutomation")
 *             .description("Data should be encrypted")
 *             .displayName("Password Policy")
 *             .remediationDescription("Encrypt store by...")
 *             .resourceGroupName("TestResourceGroup")
 *             .severity("Medium")
 *             .supportedCloud("AWS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:CustomAssessmentAutomation 33e7cc6e-a139-4723-a0e5-76993aee0771 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Security/customAssessmentAutomations/{customAssessmentAutomationName}
 * ```
 * @property compressedQuery Base 64 encoded KQL query representing the assessment automation results required.
 * @property customAssessmentAutomationName Name of the Custom Assessment Automation.
 * @property description The description to relate to the assessments generated by this assessment automation.
 * @property displayName The display name of the assessments generated by this assessment automation.
 * @property remediationDescription The remediation description to relate to the assessments generated by this assessment automation.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property severity The severity to relate to the assessments generated by this assessment automation.
 * @property supportedCloud Relevant cloud for the custom assessment automation.
 */
public data class CustomAssessmentAutomationArgs(
    public val compressedQuery: Output<String>? = null,
    public val customAssessmentAutomationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val remediationDescription: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val severity: Output<Either<String, SeverityEnum>>? = null,
    public val supportedCloud: Output<Either<String, SupportedCloudEnum>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.CustomAssessmentAutomationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.CustomAssessmentAutomationArgs =
        com.pulumi.azurenative.security.CustomAssessmentAutomationArgs.builder()
            .compressedQuery(compressedQuery?.applyValue({ args0 -> args0 }))
            .customAssessmentAutomationName(customAssessmentAutomationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .remediationDescription(remediationDescription?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .severity(
                severity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .supportedCloud(
                supportedCloud?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomAssessmentAutomationArgs].
 */
@PulumiTagMarker
public class CustomAssessmentAutomationArgsBuilder internal constructor() {
    private var compressedQuery: Output<String>? = null

    private var customAssessmentAutomationName: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var remediationDescription: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var severity: Output<Either<String, SeverityEnum>>? = null

    private var supportedCloud: Output<Either<String, SupportedCloudEnum>>? = null

    /**
     * @param value Base 64 encoded KQL query representing the assessment automation results required.
     */
    @JvmName("mjoubcepvlsjyhxw")
    public suspend fun compressedQuery(`value`: Output<String>) {
        this.compressedQuery = value
    }

    /**
     * @param value Name of the Custom Assessment Automation.
     */
    @JvmName("sfmopdjsfhhsjhbm")
    public suspend fun customAssessmentAutomationName(`value`: Output<String>) {
        this.customAssessmentAutomationName = value
    }

    /**
     * @param value The description to relate to the assessments generated by this assessment automation.
     */
    @JvmName("iwcimqjegyujudsn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the assessments generated by this assessment automation.
     */
    @JvmName("dduifhkrmbiwgvyi")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The remediation description to relate to the assessments generated by this assessment automation.
     */
    @JvmName("rwgcuyodmxlvqmjn")
    public suspend fun remediationDescription(`value`: Output<String>) {
        this.remediationDescription = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("uanhkjfnrrwumwrs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The severity to relate to the assessments generated by this assessment automation.
     */
    @JvmName("pbywugkgvpsklhdv")
    public suspend fun severity(`value`: Output<Either<String, SeverityEnum>>) {
        this.severity = value
    }

    /**
     * @param value Relevant cloud for the custom assessment automation.
     */
    @JvmName("ogxxjsnqkdwttphi")
    public suspend fun supportedCloud(`value`: Output<Either<String, SupportedCloudEnum>>) {
        this.supportedCloud = value
    }

    /**
     * @param value Base 64 encoded KQL query representing the assessment automation results required.
     */
    @JvmName("mghfxqooddrjtxmj")
    public suspend fun compressedQuery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressedQuery = mapped
    }

    /**
     * @param value Name of the Custom Assessment Automation.
     */
    @JvmName("oipiwfglwnrunlci")
    public suspend fun customAssessmentAutomationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customAssessmentAutomationName = mapped
    }

    /**
     * @param value The description to relate to the assessments generated by this assessment automation.
     */
    @JvmName("yfmspmkmdrdpuief")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the assessments generated by this assessment automation.
     */
    @JvmName("uwsdtooctiabsjge")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The remediation description to relate to the assessments generated by this assessment automation.
     */
    @JvmName("wxeenrkkfylxrodw")
    public suspend fun remediationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationDescription = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("lykqfmfvlhwmexvv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The severity to relate to the assessments generated by this assessment automation.
     */
    @JvmName("rerynitlqeukambb")
    public suspend fun severity(`value`: Either<String, SeverityEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity to relate to the assessments generated by this assessment automation.
     */
    @JvmName("rjybqnnryxdoitma")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SeverityEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity to relate to the assessments generated by this assessment automation.
     */
    @JvmName("goypmeabdtgxjwyo")
    public fun severity(`value`: SeverityEnum) {
        val toBeMapped = Either.ofRight<String, SeverityEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value Relevant cloud for the custom assessment automation.
     */
    @JvmName("cdtfkqdamcpfebcu")
    public suspend fun supportedCloud(`value`: Either<String, SupportedCloudEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedCloud = mapped
    }

    /**
     * @param value Relevant cloud for the custom assessment automation.
     */
    @JvmName("xcwrpmvghehiniol")
    public fun supportedCloud(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportedCloudEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedCloud = mapped
    }

    /**
     * @param value Relevant cloud for the custom assessment automation.
     */
    @JvmName("hflckgufmvxjfjpe")
    public fun supportedCloud(`value`: SupportedCloudEnum) {
        val toBeMapped = Either.ofRight<String, SupportedCloudEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedCloud = mapped
    }

    internal fun build(): CustomAssessmentAutomationArgs = CustomAssessmentAutomationArgs(
        compressedQuery = compressedQuery,
        customAssessmentAutomationName = customAssessmentAutomationName,
        description = description,
        displayName = displayName,
        remediationDescription = remediationDescription,
        resourceGroupName = resourceGroupName,
        severity = severity,
        supportedCloud = supportedCloud,
    )
}
