@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.PricingArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.Enforce
import com.pulumi.azurenative.security.kotlin.enums.PricingTier
import com.pulumi.azurenative.security.kotlin.inputs.ExtensionArgs
import com.pulumi.azurenative.security.kotlin.inputs.ExtensionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
 * Azure REST API version: 2024-01-01.
 * ## Example Usage
 * ### Update pricing on resource (example for VirtualMachines plan)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         PricingName = "virtualMachines",
 *         PricingTier = "Standard",
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/DEMO/providers/Microsoft.Compute/virtualMachines/VM-1",
 *         SubPlan = "P1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			PricingName: pulumi.String("virtualMachines"),
 * 			PricingTier: pulumi.String("Standard"),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/DEMO/providers/Microsoft.Compute/virtualMachines/VM-1"),
 * 			SubPlan:     pulumi.String("P1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .pricingName("virtualMachines")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/DEMO/providers/Microsoft.Compute/virtualMachines/VM-1")
 *             .subPlan("P1")
 *             .build());
 *     }
 * }
 * ```
 * ### Update pricing on subscription (example for CloudPosture plan)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         PricingName = "CloudPosture",
 *         PricingTier = "Standard",
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			PricingName: pulumi.String("CloudPosture"),
 * 			PricingTier: pulumi.String("Standard"),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .pricingName("CloudPosture")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .build());
 *     }
 * }
 * ```
 * ### Update pricing on subscription (example for CloudPosture plan) - partial success
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         PricingName = "CloudPosture",
 *         PricingTier = "Standard",
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			PricingName: pulumi.String("CloudPosture"),
 * 			PricingTier: pulumi.String("Standard"),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .pricingName("CloudPosture")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .build());
 *     }
 * }
 * ```
 * ### Update pricing on subscription (example for VirtualMachines plan)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pricing = new AzureNative.Security.Pricing("pricing", new()
 *     {
 *         Enforce = "True",
 *         PricingName = "VirtualMachines",
 *         PricingTier = "Standard",
 *         ScopeId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         SubPlan = "P2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewPricing(ctx, "pricing", &security.PricingArgs{
 * 			Enforce:     pulumi.String("True"),
 * 			PricingName: pulumi.String("VirtualMachines"),
 * 			PricingTier: pulumi.String("Standard"),
 * 			ScopeId:     pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			SubPlan:     pulumi.String("P2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Pricing;
 * import com.pulumi.azurenative.security.PricingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pricing = new Pricing("pricing", PricingArgs.builder()
 *             .enforce("True")
 *             .pricingName("VirtualMachines")
 *             .pricingTier("Standard")
 *             .scopeId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .subPlan("P2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Pricing VirtualMachines /{scopeId}/providers/Microsoft.Security/pricings/{pricingName}
 * ```
 * @property enforce If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
 * @property extensions Optional. List of extensions offered under a plan.
 * @property pricingName name of the pricing configuration
 * @property pricingTier Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
 * @property scopeId The scope id of the pricing. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or a specific resource (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}) - Supported resources are (VirtualMachines)
 * @property subPlan The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables a set of security features. When not specified, full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2', where for resource level only 'P1' sub plan is supported.
 */
public data class PricingArgs(
    public val enforce: Output<Either<String, Enforce>>? = null,
    public val extensions: Output<List<ExtensionArgs>>? = null,
    public val pricingName: Output<String>? = null,
    public val pricingTier: Output<Either<String, PricingTier>>? = null,
    public val scopeId: Output<String>? = null,
    public val subPlan: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.PricingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.PricingArgs =
        com.pulumi.azurenative.security.PricingArgs.builder()
            .enforce(
                enforce?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pricingName(pricingName?.applyValue({ args0 -> args0 }))
            .pricingTier(
                pricingTier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scopeId(scopeId?.applyValue({ args0 -> args0 }))
            .subPlan(subPlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PricingArgs].
 */
@PulumiTagMarker
public class PricingArgsBuilder internal constructor() {
    private var enforce: Output<Either<String, Enforce>>? = null

    private var extensions: Output<List<ExtensionArgs>>? = null

    private var pricingName: Output<String>? = null

    private var pricingTier: Output<Either<String, PricingTier>>? = null

    private var scopeId: Output<String>? = null

    private var subPlan: Output<String>? = null

    /**
     * @param value If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
     */
    @JvmName("ohffletqgchvljar")
    public suspend fun enforce(`value`: Output<Either<String, Enforce>>) {
        this.enforce = value
    }

    /**
     * @param value Optional. List of extensions offered under a plan.
     */
    @JvmName("hmevjcdingfkuprm")
    public suspend fun extensions(`value`: Output<List<ExtensionArgs>>) {
        this.extensions = value
    }

    @JvmName("abnrrrbnqscssvhw")
    public suspend fun extensions(vararg values: Output<ExtensionArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values Optional. List of extensions offered under a plan.
     */
    @JvmName("pcbidknbeeacfqaj")
    public suspend fun extensions(values: List<Output<ExtensionArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value name of the pricing configuration
     */
    @JvmName("uocawqntidfxthha")
    public suspend fun pricingName(`value`: Output<String>) {
        this.pricingName = value
    }

    /**
     * @param value Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    @JvmName("sjimilwnbtaykdin")
    public suspend fun pricingTier(`value`: Output<Either<String, PricingTier>>) {
        this.pricingTier = value
    }

    /**
     * @param value The scope id of the pricing. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or a specific resource (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}) - Supported resources are (VirtualMachines)
     */
    @JvmName("rhwfbmrdqecntsyj")
    public suspend fun scopeId(`value`: Output<String>) {
        this.scopeId = value
    }

    /**
     * @param value The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables a set of security features. When not specified, full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2', where for resource level only 'P1' sub plan is supported.
     */
    @JvmName("urmvaidfpvscmxnu")
    public suspend fun subPlan(`value`: Output<String>) {
        this.subPlan = value
    }

    /**
     * @param value If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
     */
    @JvmName("mqhijdopwqcurvis")
    public suspend fun enforce(`value`: Either<String, Enforce>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforce = mapped
    }

    /**
     * @param value If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
     */
    @JvmName("tavcdfeygnddrtuy")
    public fun enforce(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Enforce>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforce = mapped
    }

    /**
     * @param value If set to "False", it allows the descendants of this scope to override the pricing configuration set on this scope (allows setting inherited="False"). If set to "True", it prevents overrides and forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level pricing.
     */
    @JvmName("hdbgclqnxjemelya")
    public fun enforce(`value`: Enforce) {
        val toBeMapped = Either.ofRight<String, Enforce>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforce = mapped
    }

    /**
     * @param value Optional. List of extensions offered under a plan.
     */
    @JvmName("kcludydeqlkmdmjd")
    public suspend fun extensions(`value`: List<ExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument Optional. List of extensions offered under a plan.
     */
    @JvmName("ewtcndcfcbixjinr")
    public suspend fun extensions(argument: List<suspend ExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ExtensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument Optional. List of extensions offered under a plan.
     */
    @JvmName("kvwcrvtgkhlsncao")
    public suspend fun extensions(vararg argument: suspend ExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ExtensionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument Optional. List of extensions offered under a plan.
     */
    @JvmName("akfhoogbytalkyao")
    public suspend fun extensions(argument: suspend ExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values Optional. List of extensions offered under a plan.
     */
    @JvmName("vcfpoeptdcypmilk")
    public suspend fun extensions(vararg values: ExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value name of the pricing configuration
     */
    @JvmName("nnsratckrdmdjxnx")
    public suspend fun pricingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingName = mapped
    }

    /**
     * @param value Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    @JvmName("dmeohwiyxuxmjhaw")
    public suspend fun pricingTier(`value`: Either<String, PricingTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingTier = mapped
    }

    /**
     * @param value Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    @JvmName("yamyrqxonyobdvsc")
    public fun pricingTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pricingTier = mapped
    }

    /**
     * @param value Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    @JvmName("imkyixmoqqllviqo")
    public fun pricingTier(`value`: PricingTier) {
        val toBeMapped = Either.ofRight<String, PricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pricingTier = mapped
    }

    /**
     * @param value The scope id of the pricing. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or a specific resource (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}) - Supported resources are (VirtualMachines)
     */
    @JvmName("eemblmnjfveelect")
    public suspend fun scopeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeId = mapped
    }

    /**
     * @param value The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables a set of security features. When not specified, full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2', where for resource level only 'P1' sub plan is supported.
     */
    @JvmName("nfnfnbbghdnjgioj")
    public suspend fun subPlan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subPlan = mapped
    }

    internal fun build(): PricingArgs = PricingArgs(
        enforce = enforce,
        extensions = extensions,
        pricingName = pricingName,
        pricingTier = pricingTier,
        scopeId = scopeId,
        subPlan = subPlan,
    )
}
