@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.SecurityConnectorApplicationArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.ApplicationSourceResourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Security Application over a given scope
 * Azure REST API version: 2022-07-01-preview. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * ## Example Usage
 * ### Create Application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityConnectorApplication = new AzureNative.Security.SecurityConnectorApplication("securityConnectorApplication", new()
 *     {
 *         ApplicationId = "ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
 *         Description = "An application on critical GCP recommendations",
 *         DisplayName = "GCP Admin's application",
 *         ResourceGroupName = "gcpResourceGroup",
 *         SecurityConnectorName = "gcpconnector",
 *         SourceResourceType = "Assessments",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityConnectorApplication(ctx, "securityConnectorApplication", &security.SecurityConnectorApplicationArgs{
 * 			ApplicationId:         pulumi.String("ad9a8e26-29d9-4829-bb30-e597a58cdbb8"),
 * 			Description:           pulumi.String("An application on critical GCP recommendations"),
 * 			DisplayName:           pulumi.String("GCP Admin's application"),
 * 			ResourceGroupName:     pulumi.String("gcpResourceGroup"),
 * 			SecurityConnectorName: pulumi.String("gcpconnector"),
 * 			SourceResourceType:    pulumi.String("Assessments"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityConnectorApplication;
 * import com.pulumi.azurenative.security.SecurityConnectorApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityConnectorApplication = new SecurityConnectorApplication("securityConnectorApplication", SecurityConnectorApplicationArgs.builder()
 *             .applicationId("ad9a8e26-29d9-4829-bb30-e597a58cdbb8")
 *             .description("An application on critical GCP recommendations")
 *             .displayName("GCP Admin's application")
 *             .resourceGroupName("gcpResourceGroup")
 *             .securityConnectorName("gcpconnector")
 *             .sourceResourceType("Assessments")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityConnectorApplication 1f3afdf9-d0c9-4c3d-847f-89da613e70a8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/providers/Microsoft.Security/applications/{applicationId}
 * ```
 * @property applicationId The security Application key - unique key for the standard application
 * @property description description of the application
 * @property displayName display name of the application
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 * @property sourceResourceType The application source, what it affects, e.g. Assessments
 */
public data class SecurityConnectorApplicationArgs(
    public val applicationId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityConnectorName: Output<String>? = null,
    public val sourceResourceType: Output<Either<String, ApplicationSourceResourceType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.SecurityConnectorApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.SecurityConnectorApplicationArgs =
        com.pulumi.azurenative.security.SecurityConnectorApplicationArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName?.applyValue({ args0 -> args0 }))
            .sourceResourceType(
                sourceResourceType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [SecurityConnectorApplicationArgs].
 */
@PulumiTagMarker
public class SecurityConnectorApplicationArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityConnectorName: Output<String>? = null

    private var sourceResourceType: Output<Either<String, ApplicationSourceResourceType>>? = null

    /**
     * @param value The security Application key - unique key for the standard application
     */
    @JvmName("lceoybmnegxgosqt")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value description of the application
     */
    @JvmName("thjnlxeuihhhxvcn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value display name of the application
     */
    @JvmName("wqqqeepatidalhob")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("chqyxesjmkljnduw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("slgefpkqtmrspdun")
    public suspend fun securityConnectorName(`value`: Output<String>) {
        this.securityConnectorName = value
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("cnrbebuhblchivwl")
    public suspend
    fun sourceResourceType(`value`: Output<Either<String, ApplicationSourceResourceType>>) {
        this.sourceResourceType = value
    }

    /**
     * @param value The security Application key - unique key for the standard application
     */
    @JvmName("tlkoseydteamebtt")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value description of the application
     */
    @JvmName("fohqnahluskhveae")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value display name of the application
     */
    @JvmName("fotgtwltmblfvveo")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("uvvvqvlferomsmlm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("gpcjkixjbmbatpfs")
    public suspend fun securityConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConnectorName = mapped
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("hdmuwmafxudcyjar")
    public suspend fun sourceResourceType(`value`: Either<String, ApplicationSourceResourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("maamoeidsyfhoyyb")
    public fun sourceResourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationSourceResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    /**
     * @param value The application source, what it affects, e.g. Assessments
     */
    @JvmName("ljhqowiwbepcaqhk")
    public fun sourceResourceType(`value`: ApplicationSourceResourceType) {
        val toBeMapped = Either.ofRight<String, ApplicationSourceResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResourceType = mapped
    }

    internal fun build(): SecurityConnectorApplicationArgs = SecurityConnectorApplicationArgs(
        applicationId = applicationId,
        description = description,
        displayName = displayName,
        resourceGroupName = resourceGroupName,
        securityConnectorName = securityConnectorName,
        sourceResourceType = sourceResourceType,
    )
}
