@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.SecurityConnectorArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.CloudName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The security connector resource.
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * Other available API versions: 2021-07-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update a security connector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityConnector = new AzureNative.Security.SecurityConnector("securityConnector", new()
 *     {
 *         EnvironmentData = new AzureNative.Security.Inputs.AwsEnvironmentDataArgs
 *         {
 *             EnvironmentType = "AwsAccount",
 *         },
 *         EnvironmentName = "AWS",
 *         HierarchyIdentifier = "exampleHierarchyId",
 *         Location = "Central US",
 *         Offerings = new[]
 *         {
 *             new AzureNative.Security.Inputs.CspmMonitorAwsOfferingArgs
 *             {
 *                 NativeCloudConnection = new AzureNative.Security.Inputs.CspmMonitorAwsOfferingNativeCloudConnectionArgs
 *                 {
 *                     CloudRoleArn = "arn:aws:iam::00000000:role/ASCMonitor",
 *                 },
 *                 OfferingType = "CspmMonitorAws",
 *             },
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         SecurityConnectorName = "exampleSecurityConnectorName",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityConnector(ctx, "securityConnector", &security.SecurityConnectorArgs{
 * 			EnvironmentData: security.AwsEnvironmentData{
 * 				EnvironmentType: "AwsAccount",
 * 			},
 * 			EnvironmentName:     pulumi.String("AWS"),
 * 			HierarchyIdentifier: pulumi.String("exampleHierarchyId"),
 * 			Location:            pulumi.String("Central US"),
 * 			Offerings: pulumi.Array{
 * 				security.CspmMonitorAwsOffering{
 * 					NativeCloudConnection: security.CspmMonitorAwsOfferingNativeCloudConnection{
 * 						CloudRoleArn: "arn:aws:iam::00000000:role/ASCMonitor",
 * 					},
 * 					OfferingType: "CspmMonitorAws",
 * 				},
 * 			},
 * 			ResourceGroupName:     pulumi.String("exampleResourceGroup"),
 * 			SecurityConnectorName: pulumi.String("exampleSecurityConnectorName"),
 * 			Tags:                  nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityConnector;
 * import com.pulumi.azurenative.security.SecurityConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityConnector = new SecurityConnector("securityConnector", SecurityConnectorArgs.builder()
 *             .environmentData(Map.of("environmentType", "AwsAccount"))
 *             .environmentName("AWS")
 *             .hierarchyIdentifier("exampleHierarchyId")
 *             .location("Central US")
 *             .offerings(Map.ofEntries(
 *                 Map.entry("nativeCloudConnection", Map.of("cloudRoleArn", "arn:aws:iam::00000000:role/ASCMonitor")),
 *                 Map.entry("offeringType", "CspmMonitorAws")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .securityConnectorName("exampleSecurityConnectorName")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityConnector exampleSecurityConnectorName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}
 * ```
 * @property environmentData The security connector environment data.
 * @property environmentName The multi cloud resource's cloud name.
 * @property hierarchyIdentifier The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property offerings A collection of offerings for the security connector.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 * @property tags A list of key value pairs that describe the resource.
 */
public data class SecurityConnectorArgs(
    public val environmentData: Output<Any>? = null,
    public val environmentName: Output<Either<String, CloudName>>? = null,
    public val hierarchyIdentifier: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val offerings: Output<List<Any>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityConnectorName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.SecurityConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.security.SecurityConnectorArgs =
        com.pulumi.azurenative.security.SecurityConnectorArgs.builder()
            .environmentData(environmentData?.applyValue({ args0 -> args0 }))
            .environmentName(
                environmentName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .hierarchyIdentifier(hierarchyIdentifier?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .offerings(offerings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SecurityConnectorArgs].
 */
@PulumiTagMarker
public class SecurityConnectorArgsBuilder internal constructor() {
    private var environmentData: Output<Any>? = null

    private var environmentName: Output<Either<String, CloudName>>? = null

    private var hierarchyIdentifier: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var offerings: Output<List<Any>>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityConnectorName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The security connector environment data.
     */
    @JvmName("mjagtblcpcaylkkb")
    public suspend fun environmentData(`value`: Output<Any>) {
        this.environmentData = value
    }

    /**
     * @param value The multi cloud resource's cloud name.
     */
    @JvmName("aajjemdqhqiaprrr")
    public suspend fun environmentName(`value`: Output<Either<String, CloudName>>) {
        this.environmentName = value
    }

    /**
     * @param value The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
     */
    @JvmName("ukbthtwghmtmckvl")
    public suspend fun hierarchyIdentifier(`value`: Output<String>) {
        this.hierarchyIdentifier = value
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("enpfnarnqadorvsm")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("wenlwihjkytqkviu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A collection of offerings for the security connector.
     */
    @JvmName("bkjongsemrutustq")
    public suspend fun offerings(`value`: Output<List<Any>>) {
        this.offerings = value
    }

    @JvmName("wjpebdattigfgbqo")
    public suspend fun offerings(vararg values: Output<Any>) {
        this.offerings = Output.all(values.asList())
    }

    /**
     * @param values A collection of offerings for the security connector.
     */
    @JvmName("oolqpmmtifvtbccu")
    public suspend fun offerings(values: List<Output<Any>>) {
        this.offerings = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("hcunufudlwiuqlxw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("udjleqgacvptqmbs")
    public suspend fun securityConnectorName(`value`: Output<String>) {
        this.securityConnectorName = value
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("omgqyxojkhyxxuqt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The security connector environment data.
     */
    @JvmName("ldlplvpfxyhfhicu")
    public suspend fun environmentData(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentData = mapped
    }

    /**
     * @param value The multi cloud resource's cloud name.
     */
    @JvmName("wjstxwmklqkbfmaq")
    public suspend fun environmentName(`value`: Either<String, CloudName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The multi cloud resource's cloud name.
     */
    @JvmName("rhqlveilitiqbich")
    public fun environmentName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The multi cloud resource's cloud name.
     */
    @JvmName("wiktjangoqcvjels")
    public fun environmentName(`value`: CloudName) {
        val toBeMapped = Either.ofRight<String, CloudName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
     */
    @JvmName("jymebmqmqfunrtpn")
    public suspend fun hierarchyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hierarchyIdentifier = mapped
    }

    /**
     * @param value Kind of the resource
     */
    @JvmName("ttsejpgrgdrjsuje")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Location where the resource is stored
     */
    @JvmName("ttmbvokjiytwgdlx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A collection of offerings for the security connector.
     */
    @JvmName("riwxwkqvrqulquyh")
    public suspend fun offerings(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerings = mapped
    }

    /**
     * @param values A collection of offerings for the security connector.
     */
    @JvmName("rbqnbguvrdkhptby")
    public suspend fun offerings(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offerings = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("luxnnbjspimbiuld")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("auilecfmlhvjhrdq")
    public suspend fun securityConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConnectorName = mapped
    }

    /**
     * @param value A list of key value pairs that describe the resource.
     */
    @JvmName("kfsauqbcmjdjtttf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of key value pairs that describe the resource.
     */
    @JvmName("prmmrfvjaknbkvuf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SecurityConnectorArgs = SecurityConnectorArgs(
        environmentData = environmentData,
        environmentName = environmentName,
        hierarchyIdentifier = hierarchyIdentifier,
        kind = kind,
        location = location,
        offerings = offerings,
        resourceGroupName = resourceGroupName,
        securityConnectorName = securityConnectorName,
        tags = tags,
    )
}
