@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.SecurityFunctions.getAPICollectionByAzureApiManagementServicePlain
import com.pulumi.azurenative.security.SecurityFunctions.getAPICollectionPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAdaptiveApplicationControlPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAdvancedThreatProtectionPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAlertsSuppressionRulePlain
import com.pulumi.azurenative.security.SecurityFunctions.getApplicationPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAssessmentMetadataInSubscriptionPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAssessmentPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAssessmentsMetadataSubscriptionPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAssignmentPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAutomationPlain
import com.pulumi.azurenative.security.SecurityFunctions.getAzureServersSettingPlain
import com.pulumi.azurenative.security.SecurityFunctions.getConnectorPlain
import com.pulumi.azurenative.security.SecurityFunctions.getCustomAssessmentAutomationPlain
import com.pulumi.azurenative.security.SecurityFunctions.getCustomEntityStoreAssignmentPlain
import com.pulumi.azurenative.security.SecurityFunctions.getDefenderForStoragePlain
import com.pulumi.azurenative.security.SecurityFunctions.getDevOpsConfigurationPlain
import com.pulumi.azurenative.security.SecurityFunctions.getDeviceSecurityGroupPlain
import com.pulumi.azurenative.security.SecurityFunctions.getGovernanceAssignmentPlain
import com.pulumi.azurenative.security.SecurityFunctions.getGovernanceRulePlain
import com.pulumi.azurenative.security.SecurityFunctions.getIotSecuritySolutionPlain
import com.pulumi.azurenative.security.SecurityFunctions.getJitNetworkAccessPolicyPlain
import com.pulumi.azurenative.security.SecurityFunctions.getPricingPlain
import com.pulumi.azurenative.security.SecurityFunctions.getSecurityConnectorApplicationPlain
import com.pulumi.azurenative.security.SecurityFunctions.getSecurityConnectorPlain
import com.pulumi.azurenative.security.SecurityFunctions.getSecurityContactPlain
import com.pulumi.azurenative.security.SecurityFunctions.getSecurityOperatorPlain
import com.pulumi.azurenative.security.SecurityFunctions.getServerVulnerabilityAssessmentPlain
import com.pulumi.azurenative.security.SecurityFunctions.getSqlVulnerabilityAssessmentBaselineRulePlain
import com.pulumi.azurenative.security.SecurityFunctions.getStandardPlain
import com.pulumi.azurenative.security.SecurityFunctions.getWorkspaceSettingPlain
import com.pulumi.azurenative.security.SecurityFunctions.listAzureDevOpsOrgAvailablePlain
import com.pulumi.azurenative.security.SecurityFunctions.listGitHubOwnerAvailablePlain
import com.pulumi.azurenative.security.SecurityFunctions.listGitLabGroupAvailablePlain
import com.pulumi.azurenative.security.SecurityFunctions.listGitLabSubgroupPlain
import com.pulumi.azurenative.security.kotlin.inputs.GetAPICollectionByAzureApiManagementServicePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAPICollectionByAzureApiManagementServicePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAPICollectionPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAPICollectionPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAdaptiveApplicationControlPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAdaptiveApplicationControlPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAdvancedThreatProtectionPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAdvancedThreatProtectionPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAlertsSuppressionRulePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAlertsSuppressionRulePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAssessmentMetadataInSubscriptionPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAssessmentMetadataInSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAssessmentPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAssessmentPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAssessmentsMetadataSubscriptionPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAssessmentsMetadataSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAssignmentPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAssignmentPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAutomationPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAutomationPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetAzureServersSettingPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetAzureServersSettingPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetConnectorPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetConnectorPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetCustomAssessmentAutomationPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetCustomAssessmentAutomationPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetCustomEntityStoreAssignmentPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetCustomEntityStoreAssignmentPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetDefenderForStoragePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetDefenderForStoragePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetDevOpsConfigurationPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetDevOpsConfigurationPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetDeviceSecurityGroupPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetDeviceSecurityGroupPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetGovernanceAssignmentPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetGovernanceAssignmentPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetGovernanceRulePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetGovernanceRulePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetIotSecuritySolutionPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetIotSecuritySolutionPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetJitNetworkAccessPolicyPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetJitNetworkAccessPolicyPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetPricingPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetPricingPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityConnectorApplicationPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityConnectorApplicationPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityConnectorPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityConnectorPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityContactPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityContactPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityOperatorPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetSecurityOperatorPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetServerVulnerabilityAssessmentPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetServerVulnerabilityAssessmentPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetSqlVulnerabilityAssessmentBaselineRulePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetSqlVulnerabilityAssessmentBaselineRulePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetStandardPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetStandardPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.GetWorkspaceSettingPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.GetWorkspaceSettingPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.ListAzureDevOpsOrgAvailablePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.ListAzureDevOpsOrgAvailablePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.ListGitHubOwnerAvailablePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.ListGitHubOwnerAvailablePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.ListGitLabGroupAvailablePlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.ListGitLabGroupAvailablePlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.ListGitLabSubgroupPlainArgs
import com.pulumi.azurenative.security.kotlin.inputs.ListGitLabSubgroupPlainArgsBuilder
import com.pulumi.azurenative.security.kotlin.outputs.GetAPICollectionByAzureApiManagementServiceResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAPICollectionResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAdaptiveApplicationControlResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAdvancedThreatProtectionResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAlertsSuppressionRuleResult
import com.pulumi.azurenative.security.kotlin.outputs.GetApplicationResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAssessmentMetadataInSubscriptionResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAssessmentResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAssessmentsMetadataSubscriptionResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAssignmentResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAutomationResult
import com.pulumi.azurenative.security.kotlin.outputs.GetAzureServersSettingResult
import com.pulumi.azurenative.security.kotlin.outputs.GetConnectorResult
import com.pulumi.azurenative.security.kotlin.outputs.GetCustomAssessmentAutomationResult
import com.pulumi.azurenative.security.kotlin.outputs.GetCustomEntityStoreAssignmentResult
import com.pulumi.azurenative.security.kotlin.outputs.GetDefenderForStorageResult
import com.pulumi.azurenative.security.kotlin.outputs.GetDevOpsConfigurationResult
import com.pulumi.azurenative.security.kotlin.outputs.GetDeviceSecurityGroupResult
import com.pulumi.azurenative.security.kotlin.outputs.GetGovernanceAssignmentResult
import com.pulumi.azurenative.security.kotlin.outputs.GetGovernanceRuleResult
import com.pulumi.azurenative.security.kotlin.outputs.GetIotSecuritySolutionResult
import com.pulumi.azurenative.security.kotlin.outputs.GetJitNetworkAccessPolicyResult
import com.pulumi.azurenative.security.kotlin.outputs.GetPricingResult
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityConnectorApplicationResult
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityConnectorResult
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityContactResult
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityOperatorResult
import com.pulumi.azurenative.security.kotlin.outputs.GetServerVulnerabilityAssessmentResult
import com.pulumi.azurenative.security.kotlin.outputs.GetSqlVulnerabilityAssessmentBaselineRuleResult
import com.pulumi.azurenative.security.kotlin.outputs.GetStandardResult
import com.pulumi.azurenative.security.kotlin.outputs.GetWorkspaceSettingResult
import com.pulumi.azurenative.security.kotlin.outputs.ListAzureDevOpsOrgAvailableResult
import com.pulumi.azurenative.security.kotlin.outputs.ListGitHubOwnerAvailableResult
import com.pulumi.azurenative.security.kotlin.outputs.ListGitLabGroupAvailableResult
import com.pulumi.azurenative.security.kotlin.outputs.ListGitLabSubgroupResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.security.kotlin.outputs.GetAPICollectionByAzureApiManagementServiceResult.Companion.toKotlin as getAPICollectionByAzureApiManagementServiceResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAPICollectionResult.Companion.toKotlin as getAPICollectionResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAdaptiveApplicationControlResult.Companion.toKotlin as getAdaptiveApplicationControlResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAdvancedThreatProtectionResult.Companion.toKotlin as getAdvancedThreatProtectionResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAlertsSuppressionRuleResult.Companion.toKotlin as getAlertsSuppressionRuleResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAssessmentMetadataInSubscriptionResult.Companion.toKotlin as getAssessmentMetadataInSubscriptionResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAssessmentResult.Companion.toKotlin as getAssessmentResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAssessmentsMetadataSubscriptionResult.Companion.toKotlin as getAssessmentsMetadataSubscriptionResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAssignmentResult.Companion.toKotlin as getAssignmentResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAutomationResult.Companion.toKotlin as getAutomationResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetAzureServersSettingResult.Companion.toKotlin as getAzureServersSettingResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetConnectorResult.Companion.toKotlin as getConnectorResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetCustomAssessmentAutomationResult.Companion.toKotlin as getCustomAssessmentAutomationResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetCustomEntityStoreAssignmentResult.Companion.toKotlin as getCustomEntityStoreAssignmentResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetDefenderForStorageResult.Companion.toKotlin as getDefenderForStorageResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetDevOpsConfigurationResult.Companion.toKotlin as getDevOpsConfigurationResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetDeviceSecurityGroupResult.Companion.toKotlin as getDeviceSecurityGroupResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetGovernanceAssignmentResult.Companion.toKotlin as getGovernanceAssignmentResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetGovernanceRuleResult.Companion.toKotlin as getGovernanceRuleResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetIotSecuritySolutionResult.Companion.toKotlin as getIotSecuritySolutionResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetJitNetworkAccessPolicyResult.Companion.toKotlin as getJitNetworkAccessPolicyResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetPricingResult.Companion.toKotlin as getPricingResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityConnectorApplicationResult.Companion.toKotlin as getSecurityConnectorApplicationResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityConnectorResult.Companion.toKotlin as getSecurityConnectorResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityContactResult.Companion.toKotlin as getSecurityContactResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetSecurityOperatorResult.Companion.toKotlin as getSecurityOperatorResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetServerVulnerabilityAssessmentResult.Companion.toKotlin as getServerVulnerabilityAssessmentResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetSqlVulnerabilityAssessmentBaselineRuleResult.Companion.toKotlin as getSqlVulnerabilityAssessmentBaselineRuleResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetStandardResult.Companion.toKotlin as getStandardResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.GetWorkspaceSettingResult.Companion.toKotlin as getWorkspaceSettingResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.ListAzureDevOpsOrgAvailableResult.Companion.toKotlin as listAzureDevOpsOrgAvailableResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.ListGitHubOwnerAvailableResult.Companion.toKotlin as listGitHubOwnerAvailableResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.ListGitLabGroupAvailableResult.Companion.toKotlin as listGitLabGroupAvailableResultToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.ListGitLabSubgroupResult.Companion.toKotlin as listGitLabSubgroupResultToKotlin

public object SecurityFunctions {
    /**
     * Gets an Azure API Management API if it has been onboarded to Defender for APIs. If an Azure API Management API is onboarded to Defender for APIs, the system will monitor the operations within the Azure API Management API for intrusive behaviors and provide alerts for attacks that have been detected.
     * Azure REST API version: 2022-11-20-preview.
     * @param argument null
     * @return An API collection as represented by Defender for APIs.
     */
    public suspend fun getAPICollection(argument: GetAPICollectionPlainArgs): GetAPICollectionResult =
        getAPICollectionResultToKotlin(getAPICollectionPlain(argument.toJava()).await())

    /**
     * @see [getAPICollection].
     * @param apiCollectionId A string representing the apiCollections resource within the Microsoft.Security provider namespace. This string matches the Azure API Management API name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return An API collection as represented by Defender for APIs.
     */
    public suspend fun getAPICollection(
        apiCollectionId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetAPICollectionResult {
        val argument = GetAPICollectionPlainArgs(
            apiCollectionId = apiCollectionId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAPICollectionResultToKotlin(getAPICollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAPICollection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAPICollectionPlainArgs].
     * @return An API collection as represented by Defender for APIs.
     */
    public suspend
    fun getAPICollection(argument: suspend GetAPICollectionPlainArgsBuilder.() -> Unit):
        GetAPICollectionResult {
        val builder = GetAPICollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAPICollectionResultToKotlin(getAPICollectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an Azure API Management API if it has been onboarded to Microsoft Defender for APIs. If an Azure API Management API is onboarded to Microsoft Defender for APIs, the system will monitor the operations within the Azure API Management API for intrusive behaviors and provide alerts for attacks that have been detected.
     * Azure REST API version: 2023-11-15.
     * @param argument null
     * @return An API collection as represented by Microsoft Defender for APIs.
     */
    public suspend
    fun getAPICollectionByAzureApiManagementService(argument: GetAPICollectionByAzureApiManagementServicePlainArgs):
        GetAPICollectionByAzureApiManagementServiceResult =
        getAPICollectionByAzureApiManagementServiceResultToKotlin(getAPICollectionByAzureApiManagementServicePlain(argument.toJava()).await())

    /**
     * @see [getAPICollectionByAzureApiManagementService].
     * @param apiId API revision identifier. Must be unique in the API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @return An API collection as represented by Microsoft Defender for APIs.
     */
    public suspend fun getAPICollectionByAzureApiManagementService(
        apiId: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetAPICollectionByAzureApiManagementServiceResult {
        val argument = GetAPICollectionByAzureApiManagementServicePlainArgs(
            apiId = apiId,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAPICollectionByAzureApiManagementServiceResultToKotlin(getAPICollectionByAzureApiManagementServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getAPICollectionByAzureApiManagementService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAPICollectionByAzureApiManagementServicePlainArgs].
     * @return An API collection as represented by Microsoft Defender for APIs.
     */
    public suspend
    fun getAPICollectionByAzureApiManagementService(argument: suspend GetAPICollectionByAzureApiManagementServicePlainArgsBuilder.() -> Unit):
        GetAPICollectionByAzureApiManagementServiceResult {
        val builder = GetAPICollectionByAzureApiManagementServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAPICollectionByAzureApiManagementServiceResultToKotlin(getAPICollectionByAzureApiManagementServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an application control VM/server group.
     * Azure REST API version: 2020-01-01.
     * Other available API versions: 2015-06-01-preview.
     * @param argument null
     * @return null
     */
    public suspend
    fun getAdaptiveApplicationControl(argument: GetAdaptiveApplicationControlPlainArgs):
        GetAdaptiveApplicationControlResult =
        getAdaptiveApplicationControlResultToKotlin(getAdaptiveApplicationControlPlain(argument.toJava()).await())

    /**
     * @see [getAdaptiveApplicationControl].
     * @param ascLocation The location where ASC stores the data of the subscription. can be retrieved from Get locations
     * @param groupName Name of an application control machine group
     * @return null
     */
    public suspend fun getAdaptiveApplicationControl(ascLocation: String, groupName: String):
        GetAdaptiveApplicationControlResult {
        val argument = GetAdaptiveApplicationControlPlainArgs(
            ascLocation = ascLocation,
            groupName = groupName,
        )
        return getAdaptiveApplicationControlResultToKotlin(getAdaptiveApplicationControlPlain(argument.toJava()).await())
    }

    /**
     * @see [getAdaptiveApplicationControl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAdaptiveApplicationControlPlainArgs].
     * @return null
     */
    public suspend
    fun getAdaptiveApplicationControl(argument: suspend GetAdaptiveApplicationControlPlainArgsBuilder.() -> Unit):
        GetAdaptiveApplicationControlResult {
        val builder = GetAdaptiveApplicationControlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAdaptiveApplicationControlResultToKotlin(getAdaptiveApplicationControlPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Advanced Threat Protection settings for the specified resource.
     * Azure REST API version: 2019-01-01.
     * @param argument null
     * @return The Advanced Threat Protection resource.
     */
    public suspend fun getAdvancedThreatProtection(argument: GetAdvancedThreatProtectionPlainArgs):
        GetAdvancedThreatProtectionResult =
        getAdvancedThreatProtectionResultToKotlin(getAdvancedThreatProtectionPlain(argument.toJava()).await())

    /**
     * @see [getAdvancedThreatProtection].
     * @param resourceId The identifier of the resource.
     * @param settingName Advanced Threat Protection setting name.
     * @return The Advanced Threat Protection resource.
     */
    public suspend fun getAdvancedThreatProtection(resourceId: String, settingName: String):
        GetAdvancedThreatProtectionResult {
        val argument = GetAdvancedThreatProtectionPlainArgs(
            resourceId = resourceId,
            settingName = settingName,
        )
        return getAdvancedThreatProtectionResultToKotlin(getAdvancedThreatProtectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAdvancedThreatProtection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAdvancedThreatProtectionPlainArgs].
     * @return The Advanced Threat Protection resource.
     */
    public suspend
    fun getAdvancedThreatProtection(argument: suspend GetAdvancedThreatProtectionPlainArgsBuilder.() -> Unit):
        GetAdvancedThreatProtectionResult {
        val builder = GetAdvancedThreatProtectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAdvancedThreatProtectionResultToKotlin(getAdvancedThreatProtectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get dismiss rule, with name: {alertsSuppressionRuleName}, for the given subscription
     * Azure REST API version: 2019-01-01-preview.
     * @param argument null
     * @return Describes the suppression rule
     */
    public suspend fun getAlertsSuppressionRule(argument: GetAlertsSuppressionRulePlainArgs):
        GetAlertsSuppressionRuleResult =
        getAlertsSuppressionRuleResultToKotlin(getAlertsSuppressionRulePlain(argument.toJava()).await())

    /**
     * @see [getAlertsSuppressionRule].
     * @param alertsSuppressionRuleName The unique name of the suppression alert rule
     * @return Describes the suppression rule
     */
    public suspend fun getAlertsSuppressionRule(alertsSuppressionRuleName: String):
        GetAlertsSuppressionRuleResult {
        val argument = GetAlertsSuppressionRulePlainArgs(
            alertsSuppressionRuleName = alertsSuppressionRuleName,
        )
        return getAlertsSuppressionRuleResultToKotlin(getAlertsSuppressionRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getAlertsSuppressionRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAlertsSuppressionRulePlainArgs].
     * @return Describes the suppression rule
     */
    public suspend
    fun getAlertsSuppressionRule(argument: suspend GetAlertsSuppressionRulePlainArgsBuilder.() -> Unit):
        GetAlertsSuppressionRuleResult {
        val builder = GetAlertsSuppressionRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlertsSuppressionRuleResultToKotlin(getAlertsSuppressionRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific application for the requested scope by applicationId
     * Azure REST API version: 2022-07-01-preview.
     * @param argument null
     * @return Security Application over a given scope
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationId The security Application key - unique key for the standard application
     * @return Security Application over a given scope
     */
    public suspend fun getApplication(applicationId: String): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationId = applicationId,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return Security Application over a given scope
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit):
        GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a security assessment on your scanned resource
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2020-01-01.
     * @param argument null
     * @return Security assessment on a resource - response format
     */
    public suspend fun getAssessment(argument: GetAssessmentPlainArgs): GetAssessmentResult =
        getAssessmentResultToKotlin(getAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getAssessment].
     * @param assessmentName The Assessment Key - Unique key for the assessment type
     * @param expand OData expand. Optional.
     * @param resourceId The identifier of the resource.
     * @return Security assessment on a resource - response format
     */
    public suspend fun getAssessment(
        assessmentName: String,
        expand: String? = null,
        resourceId: String,
    ): GetAssessmentResult {
        val argument = GetAssessmentPlainArgs(
            assessmentName = assessmentName,
            expand = expand,
            resourceId = resourceId,
        )
        return getAssessmentResultToKotlin(getAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAssessmentPlainArgs].
     * @return Security assessment on a resource - response format
     */
    public suspend fun getAssessment(argument: suspend GetAssessmentPlainArgsBuilder.() -> Unit):
        GetAssessmentResult {
        val builder = GetAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssessmentResultToKotlin(getAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get metadata information on an assessment type in a specific subscription
     * Azure REST API version: 2021-06-01.
     * @param argument null
     * @return Security assessment metadata response
     */
    public suspend
    fun getAssessmentMetadataInSubscription(argument: GetAssessmentMetadataInSubscriptionPlainArgs):
        GetAssessmentMetadataInSubscriptionResult =
        getAssessmentMetadataInSubscriptionResultToKotlin(getAssessmentMetadataInSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getAssessmentMetadataInSubscription].
     * @param assessmentMetadataName The Assessment Key - Unique key for the assessment type
     * @return Security assessment metadata response
     */
    public suspend fun getAssessmentMetadataInSubscription(assessmentMetadataName: String):
        GetAssessmentMetadataInSubscriptionResult {
        val argument = GetAssessmentMetadataInSubscriptionPlainArgs(
            assessmentMetadataName = assessmentMetadataName,
        )
        return getAssessmentMetadataInSubscriptionResultToKotlin(getAssessmentMetadataInSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssessmentMetadataInSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAssessmentMetadataInSubscriptionPlainArgs].
     * @return Security assessment metadata response
     */
    public suspend
    fun getAssessmentMetadataInSubscription(argument: suspend GetAssessmentMetadataInSubscriptionPlainArgsBuilder.() -> Unit):
        GetAssessmentMetadataInSubscriptionResult {
        val builder = GetAssessmentMetadataInSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssessmentMetadataInSubscriptionResultToKotlin(getAssessmentMetadataInSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get metadata information on an assessment type in a specific subscription
     * Azure REST API version: 2019-01-01-preview.
     * @param argument null
     * @return Security assessment metadata
     */
    public suspend
    fun getAssessmentsMetadataSubscription(argument: GetAssessmentsMetadataSubscriptionPlainArgs):
        GetAssessmentsMetadataSubscriptionResult =
        getAssessmentsMetadataSubscriptionResultToKotlin(getAssessmentsMetadataSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getAssessmentsMetadataSubscription].
     * @param assessmentMetadataName The Assessment Key - Unique key for the assessment type
     * @return Security assessment metadata
     */
    public suspend fun getAssessmentsMetadataSubscription(assessmentMetadataName: String):
        GetAssessmentsMetadataSubscriptionResult {
        val argument = GetAssessmentsMetadataSubscriptionPlainArgs(
            assessmentMetadataName = assessmentMetadataName,
        )
        return getAssessmentsMetadataSubscriptionResultToKotlin(getAssessmentsMetadataSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssessmentsMetadataSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAssessmentsMetadataSubscriptionPlainArgs].
     * @return Security assessment metadata
     */
    public suspend
    fun getAssessmentsMetadataSubscription(argument: suspend GetAssessmentsMetadataSubscriptionPlainArgsBuilder.() -> Unit):
        GetAssessmentsMetadataSubscriptionResult {
        val builder = GetAssessmentsMetadataSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssessmentsMetadataSubscriptionResultToKotlin(getAssessmentsMetadataSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific standard assignment for the requested scope by resourceId
     * Azure REST API version: 2021-08-01-preview.
     * @param argument null
     * @return Security Assignment on a resource group over a given scope
     */
    public suspend fun getAssignment(argument: GetAssignmentPlainArgs): GetAssignmentResult =
        getAssignmentResultToKotlin(getAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getAssignment].
     * @param assignmentId The security assignment key - unique key for the standard assignment
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return Security Assignment on a resource group over a given scope
     */
    public suspend fun getAssignment(assignmentId: String, resourceGroupName: String):
        GetAssignmentResult {
        val argument = GetAssignmentPlainArgs(
            assignmentId = assignmentId,
            resourceGroupName = resourceGroupName,
        )
        return getAssignmentResultToKotlin(getAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAssignmentPlainArgs].
     * @return Security Assignment on a resource group over a given scope
     */
    public suspend fun getAssignment(argument: suspend GetAssignmentPlainArgsBuilder.() -> Unit):
        GetAssignmentResult {
        val builder = GetAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssignmentResultToKotlin(getAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about the model of a security automation.
     * Azure REST API version: 2019-01-01-preview.
     * @param argument null
     * @return The security automation resource.
     */
    public suspend fun getAutomation(argument: GetAutomationPlainArgs): GetAutomationResult =
        getAutomationResultToKotlin(getAutomationPlain(argument.toJava()).await())

    /**
     * @see [getAutomation].
     * @param automationName The security automation name.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The security automation resource.
     */
    public suspend fun getAutomation(automationName: String, resourceGroupName: String):
        GetAutomationResult {
        val argument = GetAutomationPlainArgs(
            automationName = automationName,
            resourceGroupName = resourceGroupName,
        )
        return getAutomationResultToKotlin(getAutomationPlain(argument.toJava()).await())
    }

    /**
     * @see [getAutomation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAutomationPlainArgs].
     * @return The security automation resource.
     */
    public suspend fun getAutomation(argument: suspend GetAutomationPlainArgsBuilder.() -> Unit):
        GetAutomationResult {
        val builder = GetAutomationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutomationResultToKotlin(getAutomationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a server vulnerability assessments setting of the requested kind, that is set on the subscription
     * Azure REST API version: 2023-05-01.
     * @param argument null
     * @return A vulnerability assessments setting on Azure servers in the defined scope.
     */
    public suspend fun getAzureServersSetting(argument: GetAzureServersSettingPlainArgs):
        GetAzureServersSettingResult =
        getAzureServersSettingResultToKotlin(getAzureServersSettingPlain(argument.toJava()).await())

    /**
     * @see [getAzureServersSetting].
     * @param settingKind The kind of the server vulnerability assessments setting
     * @return A vulnerability assessments setting on Azure servers in the defined scope.
     */
    public suspend fun getAzureServersSetting(settingKind: String): GetAzureServersSettingResult {
        val argument = GetAzureServersSettingPlainArgs(
            settingKind = settingKind,
        )
        return getAzureServersSettingResultToKotlin(getAzureServersSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureServersSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetAzureServersSettingPlainArgs].
     * @return A vulnerability assessments setting on Azure servers in the defined scope.
     */
    public suspend
    fun getAzureServersSetting(argument: suspend GetAzureServersSettingPlainArgsBuilder.() -> Unit):
        GetAzureServersSettingResult {
        val builder = GetAzureServersSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzureServersSettingResultToKotlin(getAzureServersSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Details of a specific cloud account connector
     * Azure REST API version: 2020-01-01-preview.
     * @param argument null
     * @return The connector setting
     */
    public suspend fun getConnector(argument: GetConnectorPlainArgs): GetConnectorResult =
        getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())

    /**
     * @see [getConnector].
     * @param connectorName Name of the cloud account connector
     * @return The connector setting
     */
    public suspend fun getConnector(connectorName: String): GetConnectorResult {
        val argument = GetConnectorPlainArgs(
            connectorName = connectorName,
        )
        return getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetConnectorPlainArgs].
     * @return The connector setting
     */
    public suspend fun getConnector(argument: suspend GetConnectorPlainArgsBuilder.() -> Unit):
        GetConnectorResult {
        val builder = GetConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorResultToKotlin(getConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a single custom assessment automation by name for the provided subscription and resource group.
     * Azure REST API version: 2021-07-01-preview.
     * @param argument null
     * @return Custom Assessment Automation
     */
    public suspend
    fun getCustomAssessmentAutomation(argument: GetCustomAssessmentAutomationPlainArgs):
        GetCustomAssessmentAutomationResult =
        getCustomAssessmentAutomationResultToKotlin(getCustomAssessmentAutomationPlain(argument.toJava()).await())

    /**
     * @see [getCustomAssessmentAutomation].
     * @param customAssessmentAutomationName Name of the Custom Assessment Automation.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return Custom Assessment Automation
     */
    public suspend fun getCustomAssessmentAutomation(
        customAssessmentAutomationName: String,
        resourceGroupName: String,
    ): GetCustomAssessmentAutomationResult {
        val argument = GetCustomAssessmentAutomationPlainArgs(
            customAssessmentAutomationName = customAssessmentAutomationName,
            resourceGroupName = resourceGroupName,
        )
        return getCustomAssessmentAutomationResultToKotlin(getCustomAssessmentAutomationPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomAssessmentAutomation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetCustomAssessmentAutomationPlainArgs].
     * @return Custom Assessment Automation
     */
    public suspend
    fun getCustomAssessmentAutomation(argument: suspend GetCustomAssessmentAutomationPlainArgsBuilder.() -> Unit):
        GetCustomAssessmentAutomationResult {
        val builder = GetCustomAssessmentAutomationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomAssessmentAutomationResultToKotlin(getCustomAssessmentAutomationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a single custom entity store assignment by name for the provided subscription and resource group.
     * Azure REST API version: 2021-07-01-preview.
     * @param argument null
     * @return Custom entity store assignment
     */
    public suspend
    fun getCustomEntityStoreAssignment(argument: GetCustomEntityStoreAssignmentPlainArgs):
        GetCustomEntityStoreAssignmentResult =
        getCustomEntityStoreAssignmentResultToKotlin(getCustomEntityStoreAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getCustomEntityStoreAssignment].
     * @param customEntityStoreAssignmentName Name of the custom entity store assignment. Generated name is GUID.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return Custom entity store assignment
     */
    public suspend fun getCustomEntityStoreAssignment(
        customEntityStoreAssignmentName: String,
        resourceGroupName: String,
    ): GetCustomEntityStoreAssignmentResult {
        val argument = GetCustomEntityStoreAssignmentPlainArgs(
            customEntityStoreAssignmentName = customEntityStoreAssignmentName,
            resourceGroupName = resourceGroupName,
        )
        return getCustomEntityStoreAssignmentResultToKotlin(getCustomEntityStoreAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomEntityStoreAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetCustomEntityStoreAssignmentPlainArgs].
     * @return Custom entity store assignment
     */
    public suspend
    fun getCustomEntityStoreAssignment(argument: suspend GetCustomEntityStoreAssignmentPlainArgsBuilder.() -> Unit):
        GetCustomEntityStoreAssignmentResult {
        val builder = GetCustomEntityStoreAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomEntityStoreAssignmentResultToKotlin(getCustomEntityStoreAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Defender for Storage settings for the specified storage account.
     * Azure REST API version: 2022-12-01-preview.
     * @param argument null
     * @return The Defender for Storage resource.
     */
    public suspend fun getDefenderForStorage(argument: GetDefenderForStoragePlainArgs):
        GetDefenderForStorageResult =
        getDefenderForStorageResultToKotlin(getDefenderForStoragePlain(argument.toJava()).await())

    /**
     * @see [getDefenderForStorage].
     * @param resourceId The identifier of the resource.
     * @param settingName Defender for Storage setting name.
     * @return The Defender for Storage resource.
     */
    public suspend fun getDefenderForStorage(resourceId: String, settingName: String):
        GetDefenderForStorageResult {
        val argument = GetDefenderForStoragePlainArgs(
            resourceId = resourceId,
            settingName = settingName,
        )
        return getDefenderForStorageResultToKotlin(getDefenderForStoragePlain(argument.toJava()).await())
    }

    /**
     * @see [getDefenderForStorage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetDefenderForStoragePlainArgs].
     * @return The Defender for Storage resource.
     */
    public suspend
    fun getDefenderForStorage(argument: suspend GetDefenderForStoragePlainArgsBuilder.() -> Unit):
        GetDefenderForStorageResult {
        val builder = GetDefenderForStoragePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDefenderForStorageResultToKotlin(getDefenderForStoragePlain(builtArgument.toJava()).await())
    }

    /**
     * DevOps Configuration resource.
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return DevOps Configuration resource.
     */
    public suspend fun getDevOpsConfiguration(argument: GetDevOpsConfigurationPlainArgs):
        GetDevOpsConfigurationResult =
        getDevOpsConfigurationResultToKotlin(getDevOpsConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getDevOpsConfiguration].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param securityConnectorName The security connector name.
     * @return DevOps Configuration resource.
     */
    public suspend fun getDevOpsConfiguration(
        resourceGroupName: String,
        securityConnectorName: String,
    ): GetDevOpsConfigurationResult {
        val argument = GetDevOpsConfigurationPlainArgs(
            resourceGroupName = resourceGroupName,
            securityConnectorName = securityConnectorName,
        )
        return getDevOpsConfigurationResultToKotlin(getDevOpsConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDevOpsConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetDevOpsConfigurationPlainArgs].
     * @return DevOps Configuration resource.
     */
    public suspend
    fun getDevOpsConfiguration(argument: suspend GetDevOpsConfigurationPlainArgsBuilder.() -> Unit):
        GetDevOpsConfigurationResult {
        val builder = GetDevOpsConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDevOpsConfigurationResultToKotlin(getDevOpsConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this method to get the device security group for the specified IoT Hub resource.
     * Azure REST API version: 2019-08-01.
     * @param argument null
     * @return The device security group resource
     */
    public suspend fun getDeviceSecurityGroup(argument: GetDeviceSecurityGroupPlainArgs):
        GetDeviceSecurityGroupResult =
        getDeviceSecurityGroupResultToKotlin(getDeviceSecurityGroupPlain(argument.toJava()).await())

    /**
     * @see [getDeviceSecurityGroup].
     * @param deviceSecurityGroupName The name of the device security group. Note that the name of the device security group is case insensitive.
     * @param resourceId The identifier of the resource.
     * @return The device security group resource
     */
    public suspend fun getDeviceSecurityGroup(deviceSecurityGroupName: String, resourceId: String):
        GetDeviceSecurityGroupResult {
        val argument = GetDeviceSecurityGroupPlainArgs(
            deviceSecurityGroupName = deviceSecurityGroupName,
            resourceId = resourceId,
        )
        return getDeviceSecurityGroupResultToKotlin(getDeviceSecurityGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeviceSecurityGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetDeviceSecurityGroupPlainArgs].
     * @return The device security group resource
     */
    public suspend
    fun getDeviceSecurityGroup(argument: suspend GetDeviceSecurityGroupPlainArgsBuilder.() -> Unit):
        GetDeviceSecurityGroupResult {
        val builder = GetDeviceSecurityGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeviceSecurityGroupResultToKotlin(getDeviceSecurityGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific governanceAssignment for the requested scope by AssignmentKey
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Governance assignment over a given scope
     */
    public suspend fun getGovernanceAssignment(argument: GetGovernanceAssignmentPlainArgs):
        GetGovernanceAssignmentResult =
        getGovernanceAssignmentResultToKotlin(getGovernanceAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getGovernanceAssignment].
     * @param assessmentName The Assessment Key - A unique key for the assessment type
     * @param assignmentKey The governance assignment key - the assessment key of the required governance assignment
     * @param scope The scope of the Governance assignments. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     * @return Governance assignment over a given scope
     */
    public suspend fun getGovernanceAssignment(
        assessmentName: String,
        assignmentKey: String,
        scope: String,
    ): GetGovernanceAssignmentResult {
        val argument = GetGovernanceAssignmentPlainArgs(
            assessmentName = assessmentName,
            assignmentKey = assignmentKey,
            scope = scope,
        )
        return getGovernanceAssignmentResultToKotlin(getGovernanceAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGovernanceAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetGovernanceAssignmentPlainArgs].
     * @return Governance assignment over a given scope
     */
    public suspend
    fun getGovernanceAssignment(argument: suspend GetGovernanceAssignmentPlainArgsBuilder.() -> Unit):
        GetGovernanceAssignmentResult {
        val builder = GetGovernanceAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGovernanceAssignmentResultToKotlin(getGovernanceAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific governance rule for the requested scope by ruleId
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Governance rule over a given scope
     */
    public suspend fun getGovernanceRule(argument: GetGovernanceRulePlainArgs):
        GetGovernanceRuleResult =
        getGovernanceRuleResultToKotlin(getGovernanceRulePlain(argument.toJava()).await())

    /**
     * @see [getGovernanceRule].
     * @param ruleId The governance rule key - unique key for the standard governance rule (GUID)
     * @param scope The scope of the Governance rules. Valid scopes are: management group (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
     * @return Governance rule over a given scope
     */
    public suspend fun getGovernanceRule(ruleId: String, scope: String): GetGovernanceRuleResult {
        val argument = GetGovernanceRulePlainArgs(
            ruleId = ruleId,
            scope = scope,
        )
        return getGovernanceRuleResultToKotlin(getGovernanceRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getGovernanceRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetGovernanceRulePlainArgs].
     * @return Governance rule over a given scope
     */
    public suspend
    fun getGovernanceRule(argument: suspend GetGovernanceRulePlainArgsBuilder.() -> Unit):
        GetGovernanceRuleResult {
        val builder = GetGovernanceRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGovernanceRuleResultToKotlin(getGovernanceRulePlain(builtArgument.toJava()).await())
    }

    /**
     * User this method to get details of a specific IoT Security solution based on solution name
     * Azure REST API version: 2019-08-01.
     * Other available API versions: 2017-08-01-preview.
     * @param argument null
     * @return IoT Security solution configuration and resource information.
     */
    public suspend fun getIotSecuritySolution(argument: GetIotSecuritySolutionPlainArgs):
        GetIotSecuritySolutionResult =
        getIotSecuritySolutionResultToKotlin(getIotSecuritySolutionPlain(argument.toJava()).await())

    /**
     * @see [getIotSecuritySolution].
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param solutionName The name of the IoT Security solution.
     * @return IoT Security solution configuration and resource information.
     */
    public suspend fun getIotSecuritySolution(resourceGroupName: String, solutionName: String):
        GetIotSecuritySolutionResult {
        val argument = GetIotSecuritySolutionPlainArgs(
            resourceGroupName = resourceGroupName,
            solutionName = solutionName,
        )
        return getIotSecuritySolutionResultToKotlin(getIotSecuritySolutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getIotSecuritySolution].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetIotSecuritySolutionPlainArgs].
     * @return IoT Security solution configuration and resource information.
     */
    public suspend
    fun getIotSecuritySolution(argument: suspend GetIotSecuritySolutionPlainArgsBuilder.() -> Unit):
        GetIotSecuritySolutionResult {
        val builder = GetIotSecuritySolutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotSecuritySolutionResultToKotlin(getIotSecuritySolutionPlain(builtArgument.toJava()).await())
    }

    /**
     * Policies for protecting resources using Just-in-Time access control for the subscription, location
     * Azure REST API version: 2020-01-01.
     * @param argument null
     * @return null
     */
    public suspend fun getJitNetworkAccessPolicy(argument: GetJitNetworkAccessPolicyPlainArgs):
        GetJitNetworkAccessPolicyResult =
        getJitNetworkAccessPolicyResultToKotlin(getJitNetworkAccessPolicyPlain(argument.toJava()).await())

    /**
     * @see [getJitNetworkAccessPolicy].
     * @param ascLocation The location where ASC stores the data of the subscription. can be retrieved from Get locations
     * @param jitNetworkAccessPolicyName Name of a Just-in-Time access configuration policy.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return null
     */
    public suspend fun getJitNetworkAccessPolicy(
        ascLocation: String,
        jitNetworkAccessPolicyName: String,
        resourceGroupName: String,
    ): GetJitNetworkAccessPolicyResult {
        val argument = GetJitNetworkAccessPolicyPlainArgs(
            ascLocation = ascLocation,
            jitNetworkAccessPolicyName = jitNetworkAccessPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getJitNetworkAccessPolicyResultToKotlin(getJitNetworkAccessPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getJitNetworkAccessPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetJitNetworkAccessPolicyPlainArgs].
     * @return null
     */
    public suspend
    fun getJitNetworkAccessPolicy(argument: suspend GetJitNetworkAccessPolicyPlainArgsBuilder.() -> Unit):
        GetJitNetworkAccessPolicyResult {
        val builder = GetJitNetworkAccessPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJitNetworkAccessPolicyResultToKotlin(getJitNetworkAccessPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Defender plans pricing configurations of the selected scope (valid scopes are resource id or a subscription id). At the resource level, supported resource types are 'VirtualMachines, VMSS and ARC Machines'.
     * Azure REST API version: 2024-01-01.
     * @param argument null
     * @return Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    public suspend fun getPricing(argument: GetPricingPlainArgs): GetPricingResult =
        getPricingResultToKotlin(getPricingPlain(argument.toJava()).await())

    /**
     * @see [getPricing].
     * @param pricingName name of the pricing configuration
     * @param scopeId The scope id of the pricing. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or a specific resource (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}) - Supported resources are (VirtualMachines)
     * @return Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    public suspend fun getPricing(pricingName: String, scopeId: String): GetPricingResult {
        val argument = GetPricingPlainArgs(
            pricingName = pricingName,
            scopeId = scopeId,
        )
        return getPricingResultToKotlin(getPricingPlain(argument.toJava()).await())
    }

    /**
     * @see [getPricing].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetPricingPlainArgs].
     * @return Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
     */
    public suspend fun getPricing(argument: suspend GetPricingPlainArgsBuilder.() -> Unit):
        GetPricingResult {
        val builder = GetPricingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPricingResultToKotlin(getPricingPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves details of a specific security connector
     * Azure REST API version: 2023-03-01-preview.
     * Other available API versions: 2021-07-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return The security connector resource.
     */
    public suspend fun getSecurityConnector(argument: GetSecurityConnectorPlainArgs):
        GetSecurityConnectorResult =
        getSecurityConnectorResultToKotlin(getSecurityConnectorPlain(argument.toJava()).await())

    /**
     * @see [getSecurityConnector].
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param securityConnectorName The security connector name.
     * @return The security connector resource.
     */
    public suspend fun getSecurityConnector(resourceGroupName: String, securityConnectorName: String):
        GetSecurityConnectorResult {
        val argument = GetSecurityConnectorPlainArgs(
            resourceGroupName = resourceGroupName,
            securityConnectorName = securityConnectorName,
        )
        return getSecurityConnectorResultToKotlin(getSecurityConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetSecurityConnectorPlainArgs].
     * @return The security connector resource.
     */
    public suspend
    fun getSecurityConnector(argument: suspend GetSecurityConnectorPlainArgsBuilder.() -> Unit):
        GetSecurityConnectorResult {
        val builder = GetSecurityConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityConnectorResultToKotlin(getSecurityConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific application for the requested scope by applicationId
     * Azure REST API version: 2022-07-01-preview.
     * @param argument null
     * @return Security Application over a given scope
     */
    public suspend
    fun getSecurityConnectorApplication(argument: GetSecurityConnectorApplicationPlainArgs):
        GetSecurityConnectorApplicationResult =
        getSecurityConnectorApplicationResultToKotlin(getSecurityConnectorApplicationPlain(argument.toJava()).await())

    /**
     * @see [getSecurityConnectorApplication].
     * @param applicationId The security Application key - unique key for the standard application
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param securityConnectorName The security connector name.
     * @return Security Application over a given scope
     */
    public suspend fun getSecurityConnectorApplication(
        applicationId: String,
        resourceGroupName: String,
        securityConnectorName: String,
    ): GetSecurityConnectorApplicationResult {
        val argument = GetSecurityConnectorApplicationPlainArgs(
            applicationId = applicationId,
            resourceGroupName = resourceGroupName,
            securityConnectorName = securityConnectorName,
        )
        return getSecurityConnectorApplicationResultToKotlin(getSecurityConnectorApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityConnectorApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetSecurityConnectorApplicationPlainArgs].
     * @return Security Application over a given scope
     */
    public suspend
    fun getSecurityConnectorApplication(argument: suspend GetSecurityConnectorApplicationPlainArgsBuilder.() -> Unit):
        GetSecurityConnectorApplicationResult {
        val builder = GetSecurityConnectorApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityConnectorApplicationResultToKotlin(getSecurityConnectorApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Default Security contact configurations for the subscription
     * Azure REST API version: 2020-01-01-preview.
     * Other available API versions: 2017-08-01-preview.
     * @param argument null
     * @return Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
     */
    public suspend fun getSecurityContact(argument: GetSecurityContactPlainArgs):
        GetSecurityContactResult =
        getSecurityContactResultToKotlin(getSecurityContactPlain(argument.toJava()).await())

    /**
     * @see [getSecurityContact].
     * @param securityContactName Name of the security contact object
     * @return Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
     */
    public suspend fun getSecurityContact(securityContactName: String): GetSecurityContactResult {
        val argument = GetSecurityContactPlainArgs(
            securityContactName = securityContactName,
        )
        return getSecurityContactResultToKotlin(getSecurityContactPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityContact].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetSecurityContactPlainArgs].
     * @return Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
     */
    public suspend
    fun getSecurityContact(argument: suspend GetSecurityContactPlainArgsBuilder.() -> Unit):
        GetSecurityContactResult {
        val builder = GetSecurityContactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityContactResultToKotlin(getSecurityContactPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific security operator for the requested scope.
     * Azure REST API version: 2023-01-01-preview.
     * @param argument null
     * @return Security operator under a given subscription and pricing
     */
    public suspend fun getSecurityOperator(argument: GetSecurityOperatorPlainArgs):
        GetSecurityOperatorResult =
        getSecurityOperatorResultToKotlin(getSecurityOperatorPlain(argument.toJava()).await())

    /**
     * @see [getSecurityOperator].
     * @param pricingName name of the pricing configuration
     * @param securityOperatorName name of the securityOperator
     * @return Security operator under a given subscription and pricing
     */
    public suspend fun getSecurityOperator(pricingName: String, securityOperatorName: String):
        GetSecurityOperatorResult {
        val argument = GetSecurityOperatorPlainArgs(
            pricingName = pricingName,
            securityOperatorName = securityOperatorName,
        )
        return getSecurityOperatorResultToKotlin(getSecurityOperatorPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityOperator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetSecurityOperatorPlainArgs].
     * @return Security operator under a given subscription and pricing
     */
    public suspend
    fun getSecurityOperator(argument: suspend GetSecurityOperatorPlainArgsBuilder.() -> Unit):
        GetSecurityOperatorResult {
        val builder = GetSecurityOperatorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityOperatorResultToKotlin(getSecurityOperatorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server vulnerability assessment onboarding statuses on a given resource.
     * Azure REST API version: 2020-01-01.
     * @param argument null
     * @return Describes the server vulnerability assessment details on a resource
     */
    public suspend
    fun getServerVulnerabilityAssessment(argument: GetServerVulnerabilityAssessmentPlainArgs):
        GetServerVulnerabilityAssessmentResult =
        getServerVulnerabilityAssessmentResultToKotlin(getServerVulnerabilityAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getServerVulnerabilityAssessment].
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param resourceName Name of the resource.
     * @param resourceNamespace The Namespace of the resource.
     * @param resourceType The type of the resource.
     * @param serverVulnerabilityAssessment ServerVulnerabilityAssessment status. only a 'default' value is supported.
     * @return Describes the server vulnerability assessment details on a resource
     */
    public suspend fun getServerVulnerabilityAssessment(
        resourceGroupName: String,
        resourceName: String,
        resourceNamespace: String,
        resourceType: String,
        serverVulnerabilityAssessment: String,
    ): GetServerVulnerabilityAssessmentResult {
        val argument = GetServerVulnerabilityAssessmentPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            resourceNamespace = resourceNamespace,
            resourceType = resourceType,
            serverVulnerabilityAssessment = serverVulnerabilityAssessment,
        )
        return getServerVulnerabilityAssessmentResultToKotlin(getServerVulnerabilityAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerVulnerabilityAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetServerVulnerabilityAssessmentPlainArgs].
     * @return Describes the server vulnerability assessment details on a resource
     */
    public suspend
    fun getServerVulnerabilityAssessment(argument: suspend GetServerVulnerabilityAssessmentPlainArgsBuilder.() -> Unit):
        GetServerVulnerabilityAssessmentResult {
        val builder = GetServerVulnerabilityAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerVulnerabilityAssessmentResultToKotlin(getServerVulnerabilityAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Rule results.
     * Azure REST API version: 2023-02-01-preview.
     * @param argument null
     * @return Rule results.
     */
    public suspend
    fun getSqlVulnerabilityAssessmentBaselineRule(argument: GetSqlVulnerabilityAssessmentBaselineRulePlainArgs):
        GetSqlVulnerabilityAssessmentBaselineRuleResult =
        getSqlVulnerabilityAssessmentBaselineRuleResultToKotlin(getSqlVulnerabilityAssessmentBaselineRulePlain(argument.toJava()).await())

    /**
     * @see [getSqlVulnerabilityAssessmentBaselineRule].
     * @param resourceId The identifier of the resource.
     * @param ruleId The rule Id.
     * @param workspaceId The workspace Id.
     * @return Rule results.
     */
    public suspend fun getSqlVulnerabilityAssessmentBaselineRule(
        resourceId: String,
        ruleId: String,
        workspaceId: String,
    ): GetSqlVulnerabilityAssessmentBaselineRuleResult {
        val argument = GetSqlVulnerabilityAssessmentBaselineRulePlainArgs(
            resourceId = resourceId,
            ruleId = ruleId,
            workspaceId = workspaceId,
        )
        return getSqlVulnerabilityAssessmentBaselineRuleResultToKotlin(getSqlVulnerabilityAssessmentBaselineRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlVulnerabilityAssessmentBaselineRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetSqlVulnerabilityAssessmentBaselineRulePlainArgs].
     * @return Rule results.
     */
    public suspend
    fun getSqlVulnerabilityAssessmentBaselineRule(argument: suspend GetSqlVulnerabilityAssessmentBaselineRulePlainArgsBuilder.() -> Unit):
        GetSqlVulnerabilityAssessmentBaselineRuleResult {
        val builder = GetSqlVulnerabilityAssessmentBaselineRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlVulnerabilityAssessmentBaselineRuleResultToKotlin(getSqlVulnerabilityAssessmentBaselineRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific security standard for the requested scope
     * Azure REST API version: 2021-08-01-preview.
     * @param argument null
     * @return Security Standard on a resource
     */
    public suspend fun getStandard(argument: GetStandardPlainArgs): GetStandardResult =
        getStandardResultToKotlin(getStandardPlain(argument.toJava()).await())

    /**
     * @see [getStandard].
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param standardId The Security Standard key - unique key for the standard type
     * @return Security Standard on a resource
     */
    public suspend fun getStandard(resourceGroupName: String, standardId: String): GetStandardResult {
        val argument = GetStandardPlainArgs(
            resourceGroupName = resourceGroupName,
            standardId = standardId,
        )
        return getStandardResultToKotlin(getStandardPlain(argument.toJava()).await())
    }

    /**
     * @see [getStandard].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetStandardPlainArgs].
     * @return Security Standard on a resource
     */
    public suspend fun getStandard(argument: suspend GetStandardPlainArgsBuilder.() -> Unit):
        GetStandardResult {
        val builder = GetStandardPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStandardResultToKotlin(getStandardPlain(builtArgument.toJava()).await())
    }

    /**
     * Settings about where we should store your security data and logs. If the result is empty, it means that no custom-workspace configuration was set
     * Azure REST API version: 2017-08-01-preview.
     * @param argument null
     * @return Configures where to store the OMS agent data for workspaces under a scope
     */
    public suspend fun getWorkspaceSetting(argument: GetWorkspaceSettingPlainArgs):
        GetWorkspaceSettingResult =
        getWorkspaceSettingResultToKotlin(getWorkspaceSettingPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceSetting].
     * @param workspaceSettingName Name of the security setting
     * @return Configures where to store the OMS agent data for workspaces under a scope
     */
    public suspend fun getWorkspaceSetting(workspaceSettingName: String): GetWorkspaceSettingResult {
        val argument = GetWorkspaceSettingPlainArgs(
            workspaceSettingName = workspaceSettingName,
        )
        return getWorkspaceSettingResultToKotlin(getWorkspaceSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;GetWorkspaceSettingPlainArgs].
     * @return Configures where to store the OMS agent data for workspaces under a scope
     */
    public suspend
    fun getWorkspaceSetting(argument: suspend GetWorkspaceSettingPlainArgsBuilder.() -> Unit):
        GetWorkspaceSettingResult {
        val builder = GetWorkspaceSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceSettingResultToKotlin(getWorkspaceSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * List of RP resources which supports pagination.
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listAzureDevOpsOrgAvailable(argument: ListAzureDevOpsOrgAvailablePlainArgs):
        ListAzureDevOpsOrgAvailableResult =
        listAzureDevOpsOrgAvailableResultToKotlin(listAzureDevOpsOrgAvailablePlain(argument.toJava()).await())

    /**
     * @see [listAzureDevOpsOrgAvailable].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param securityConnectorName The security connector name.
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listAzureDevOpsOrgAvailable(
        resourceGroupName: String,
        securityConnectorName: String,
    ): ListAzureDevOpsOrgAvailableResult {
        val argument = ListAzureDevOpsOrgAvailablePlainArgs(
            resourceGroupName = resourceGroupName,
            securityConnectorName = securityConnectorName,
        )
        return listAzureDevOpsOrgAvailableResultToKotlin(listAzureDevOpsOrgAvailablePlain(argument.toJava()).await())
    }

    /**
     * @see [listAzureDevOpsOrgAvailable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;ListAzureDevOpsOrgAvailablePlainArgs].
     * @return List of RP resources which supports pagination.
     */
    public suspend
    fun listAzureDevOpsOrgAvailable(argument: suspend ListAzureDevOpsOrgAvailablePlainArgsBuilder.() -> Unit):
        ListAzureDevOpsOrgAvailableResult {
        val builder = ListAzureDevOpsOrgAvailablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAzureDevOpsOrgAvailableResultToKotlin(listAzureDevOpsOrgAvailablePlain(builtArgument.toJava()).await())
    }

    /**
     * List of RP resources which supports pagination.
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listGitHubOwnerAvailable(argument: ListGitHubOwnerAvailablePlainArgs):
        ListGitHubOwnerAvailableResult =
        listGitHubOwnerAvailableResultToKotlin(listGitHubOwnerAvailablePlain(argument.toJava()).await())

    /**
     * @see [listGitHubOwnerAvailable].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param securityConnectorName The security connector name.
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listGitHubOwnerAvailable(
        resourceGroupName: String,
        securityConnectorName: String,
    ): ListGitHubOwnerAvailableResult {
        val argument = ListGitHubOwnerAvailablePlainArgs(
            resourceGroupName = resourceGroupName,
            securityConnectorName = securityConnectorName,
        )
        return listGitHubOwnerAvailableResultToKotlin(listGitHubOwnerAvailablePlain(argument.toJava()).await())
    }

    /**
     * @see [listGitHubOwnerAvailable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;ListGitHubOwnerAvailablePlainArgs].
     * @return List of RP resources which supports pagination.
     */
    public suspend
    fun listGitHubOwnerAvailable(argument: suspend ListGitHubOwnerAvailablePlainArgsBuilder.() -> Unit):
        ListGitHubOwnerAvailableResult {
        val builder = ListGitHubOwnerAvailablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGitHubOwnerAvailableResultToKotlin(listGitHubOwnerAvailablePlain(builtArgument.toJava()).await())
    }

    /**
     * List of RP resources which supports pagination.
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listGitLabGroupAvailable(argument: ListGitLabGroupAvailablePlainArgs):
        ListGitLabGroupAvailableResult =
        listGitLabGroupAvailableResultToKotlin(listGitLabGroupAvailablePlain(argument.toJava()).await())

    /**
     * @see [listGitLabGroupAvailable].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param securityConnectorName The security connector name.
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listGitLabGroupAvailable(
        resourceGroupName: String,
        securityConnectorName: String,
    ): ListGitLabGroupAvailableResult {
        val argument = ListGitLabGroupAvailablePlainArgs(
            resourceGroupName = resourceGroupName,
            securityConnectorName = securityConnectorName,
        )
        return listGitLabGroupAvailableResultToKotlin(listGitLabGroupAvailablePlain(argument.toJava()).await())
    }

    /**
     * @see [listGitLabGroupAvailable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;ListGitLabGroupAvailablePlainArgs].
     * @return List of RP resources which supports pagination.
     */
    public suspend
    fun listGitLabGroupAvailable(argument: suspend ListGitLabGroupAvailablePlainArgsBuilder.() -> Unit):
        ListGitLabGroupAvailableResult {
        val builder = ListGitLabGroupAvailablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGitLabGroupAvailableResultToKotlin(listGitLabGroupAvailablePlain(builtArgument.toJava()).await())
    }

    /**
     * List of RP resources which supports pagination.
     * Azure REST API version: 2023-09-01-preview.
     * @param argument null
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listGitLabSubgroup(argument: ListGitLabSubgroupPlainArgs):
        ListGitLabSubgroupResult =
        listGitLabSubgroupResultToKotlin(listGitLabSubgroupPlain(argument.toJava()).await())

    /**
     * @see [listGitLabSubgroup].
     * @param groupFQName The GitLab group fully-qualified name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param securityConnectorName The security connector name.
     * @return List of RP resources which supports pagination.
     */
    public suspend fun listGitLabSubgroup(
        groupFQName: String,
        resourceGroupName: String,
        securityConnectorName: String,
    ): ListGitLabSubgroupResult {
        val argument = ListGitLabSubgroupPlainArgs(
            groupFQName = groupFQName,
            resourceGroupName = resourceGroupName,
            securityConnectorName = securityConnectorName,
        )
        return listGitLabSubgroupResultToKotlin(listGitLabSubgroupPlain(argument.toJava()).await())
    }

    /**
     * @see [listGitLabSubgroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;security&#46;kotlin&#46;inputs&#46;ListGitLabSubgroupPlainArgs].
     * @return List of RP resources which supports pagination.
     */
    public suspend
    fun listGitLabSubgroup(argument: suspend ListGitLabSubgroupPlainArgsBuilder.() -> Unit):
        ListGitLabSubgroupResult {
        val builder = ListGitLabSubgroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGitLabSubgroupResultToKotlin(listGitLabSubgroupPlain(builtArgument.toJava()).await())
    }
}
