@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security capabilities, while the free tier offers basic security features.
 */
public enum class PricingTier(
    public val javaValue: com.pulumi.azurenative.security.enums.PricingTier,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.PricingTier> {
    /**
     * Get free Microsoft Defender for Cloud experience with basic security features
     */
    Free(com.pulumi.azurenative.security.enums.PricingTier.Free),

    /**
     * Get the standard Microsoft Defender for Cloud experience with advanced security features
     */
    Standard(com.pulumi.azurenative.security.enums.PricingTier.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.PricingTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.PricingTier): PricingTier =
            PricingTier.values().first { it.javaValue == javaType }
    }
}
