@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AutomationActionEventHubArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The target Event Hub to which event data will be exported. To learn more about Microsoft Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
 * @property actionType The type of the action that will be triggered by the Automation
 * Expected value is 'EventHub'.
 * @property connectionString The target Event Hub connection string (it will not be included in any response).
 * @property eventHubResourceId The target Event Hub Azure Resource ID.
 */
public data class AutomationActionEventHubArgs(
    public val actionType: Output<String>,
    public val connectionString: Output<String>? = null,
    public val eventHubResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AutomationActionEventHubArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AutomationActionEventHubArgs =
        com.pulumi.azurenative.security.inputs.AutomationActionEventHubArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationActionEventHubArgs].
 */
@PulumiTagMarker
public class AutomationActionEventHubArgsBuilder internal constructor() {
    private var actionType: Output<String>? = null

    private var connectionString: Output<String>? = null

    private var eventHubResourceId: Output<String>? = null

    /**
     * @param value The type of the action that will be triggered by the Automation
     * Expected value is 'EventHub'.
     */
    @JvmName("katjveadgvknijmg")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value The target Event Hub connection string (it will not be included in any response).
     */
    @JvmName("dmbjghfhcrftkimb")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value The target Event Hub Azure Resource ID.
     */
    @JvmName("fmusuicusevxdrkg")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value The type of the action that will be triggered by the Automation
     * Expected value is 'EventHub'.
     */
    @JvmName("mfgmgykqygmnjewy")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value The target Event Hub connection string (it will not be included in any response).
     */
    @JvmName("qbavplefftpycpjf")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The target Event Hub Azure Resource ID.
     */
    @JvmName("nlpunnmhvkmkhvwt")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    internal fun build(): AutomationActionEventHubArgs = AutomationActionEventHubArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        connectionString = connectionString,
        eventHubResourceId = eventHubResourceId,
    )
}
