@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AutomationTriggeringRuleArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.Operator
import com.pulumi.azurenative.security.kotlin.enums.PropertyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule which is evaluated upon event interception. The rule is configured by comparing a specific value from the event model to an expected value. This comparison is done by using one of the supported operators set.
 * @property expectedValue The expected value.
 * @property operator A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
 * @property propertyJPath The JPath of the entity model property that should be checked.
 * @property propertyType The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
 */
public data class AutomationTriggeringRuleArgs(
    public val expectedValue: Output<String>? = null,
    public val `operator`: Output<Either<String, Operator>>? = null,
    public val propertyJPath: Output<String>? = null,
    public val propertyType: Output<Either<String, PropertyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AutomationTriggeringRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AutomationTriggeringRuleArgs =
        com.pulumi.azurenative.security.inputs.AutomationTriggeringRuleArgs.builder()
            .expectedValue(expectedValue?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .propertyJPath(propertyJPath?.applyValue({ args0 -> args0 }))
            .propertyType(
                propertyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AutomationTriggeringRuleArgs].
 */
@PulumiTagMarker
public class AutomationTriggeringRuleArgsBuilder internal constructor() {
    private var expectedValue: Output<String>? = null

    private var `operator`: Output<Either<String, Operator>>? = null

    private var propertyJPath: Output<String>? = null

    private var propertyType: Output<Either<String, PropertyType>>? = null

    /**
     * @param value The expected value.
     */
    @JvmName("trsdnwrwmacwdjhp")
    public suspend fun expectedValue(`value`: Output<String>) {
        this.expectedValue = value
    }

    /**
     * @param value A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
     */
    @JvmName("urpjnvbcyiklcqoj")
    public suspend fun `operator`(`value`: Output<Either<String, Operator>>) {
        this.`operator` = value
    }

    /**
     * @param value The JPath of the entity model property that should be checked.
     */
    @JvmName("eqajicpmwbpxirkm")
    public suspend fun propertyJPath(`value`: Output<String>) {
        this.propertyJPath = value
    }

    /**
     * @param value The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
     */
    @JvmName("auxvknkyyblubqkm")
    public suspend fun propertyType(`value`: Output<Either<String, PropertyType>>) {
        this.propertyType = value
    }

    /**
     * @param value The expected value.
     */
    @JvmName("lunubilphqbjgnyc")
    public suspend fun expectedValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedValue = mapped
    }

    /**
     * @param value A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
     */
    @JvmName("cnfptfvxesejqqot")
    public suspend fun `operator`(`value`: Either<String, Operator>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
     */
    @JvmName("rhdmxougxnabdsfb")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
     */
    @JvmName("wxeyknyxrihctapa")
    public fun `operator`(`value`: Operator) {
        val toBeMapped = Either.ofRight<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The JPath of the entity model property that should be checked.
     */
    @JvmName("ricidebinliwwkxl")
    public suspend fun propertyJPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyJPath = mapped
    }

    /**
     * @param value The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
     */
    @JvmName("ephwwwcdnnqrlmhr")
    public suspend fun propertyType(`value`: Either<String, PropertyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyType = mapped
    }

    /**
     * @param value The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
     */
    @JvmName("kjestgldijqjnqlq")
    public fun propertyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyType = mapped
    }

    /**
     * @param value The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
     */
    @JvmName("kkxsoycferhcdlub")
    public fun propertyType(`value`: PropertyType) {
        val toBeMapped = Either.ofRight<String, PropertyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyType = mapped
    }

    internal fun build(): AutomationTriggeringRuleArgs = AutomationTriggeringRuleArgs(
        expectedValue = expectedValue,
        `operator` = `operator`,
        propertyJPath = propertyJPath,
        propertyType = propertyType,
    )
}
