@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingVmScannersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Microsoft Defender for Server VM scanning configuration
 * @property configuration configuration for Microsoft Defender for Server VM scanning
 * @property enabled Is Microsoft Defender for Server VM scanning enabled
 */
public data class DefenderCspmAwsOfferingVmScannersArgs(
    public val configuration: Output<DefenderCspmAwsOfferingConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingVmScannersArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingVmScannersArgs =
        com.pulumi.azurenative.security.inputs.DefenderCspmAwsOfferingVmScannersArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderCspmAwsOfferingVmScannersArgs].
 */
@PulumiTagMarker
public class DefenderCspmAwsOfferingVmScannersArgsBuilder internal constructor() {
    private var configuration: Output<DefenderCspmAwsOfferingConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("pnkbrccbqfdnwlvs")
    public suspend fun configuration(`value`: Output<DefenderCspmAwsOfferingConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is Microsoft Defender for Server VM scanning enabled
     */
    @JvmName("ionhsneynkinmsxn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("unehookhgxshvldb")
    public suspend fun configuration(`value`: DefenderCspmAwsOfferingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument configuration for Microsoft Defender for Server VM scanning
     */
    @JvmName("xvmnnyfkafnbbbve")
    public suspend
    fun configuration(argument: suspend DefenderCspmAwsOfferingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderCspmAwsOfferingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is Microsoft Defender for Server VM scanning enabled
     */
    @JvmName("yyreutdwlyvnfwwu")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderCspmAwsOfferingVmScannersArgs =
        DefenderCspmAwsOfferingVmScannersArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
