@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The containers GCP offering
 * @property auditLogsAutoProvisioningFlag Is audit logs data collection enabled
 * @property dataPipelineNativeCloudConnection The native cloud connection configuration
 * @property defenderAgentAutoProvisioningFlag Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
 * @property nativeCloudConnection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForContainersGcp'.
 * @property policyAgentAutoProvisioningFlag Is Policy Kubernetes agent auto provisioning enabled
 */
public data class DefenderForContainersGcpOfferingArgs(
    public val auditLogsAutoProvisioningFlag: Output<Boolean>? = null,
    public val dataPipelineNativeCloudConnection:
    Output<DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs>? = null,
    public val defenderAgentAutoProvisioningFlag: Output<Boolean>? = null,
    public val nativeCloudConnection:
    Output<DefenderForContainersGcpOfferingNativeCloudConnectionArgs>? = null,
    public val offeringType: Output<String>,
    public val policyAgentAutoProvisioningFlag: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderForContainersGcpOfferingArgs.builder()
            .auditLogsAutoProvisioningFlag(auditLogsAutoProvisioningFlag?.applyValue({ args0 -> args0 }))
            .dataPipelineNativeCloudConnection(
                dataPipelineNativeCloudConnection?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .defenderAgentAutoProvisioningFlag(
                defenderAgentAutoProvisioningFlag?.applyValue({ args0 ->
                    args0
                }),
            )
            .nativeCloudConnection(
                nativeCloudConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .offeringType(offeringType.applyValue({ args0 -> args0 }))
            .policyAgentAutoProvisioningFlag(
                policyAgentAutoProvisioningFlag?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DefenderForContainersGcpOfferingArgs].
 */
@PulumiTagMarker
public class DefenderForContainersGcpOfferingArgsBuilder internal constructor() {
    private var auditLogsAutoProvisioningFlag: Output<Boolean>? = null

    private var dataPipelineNativeCloudConnection:
        Output<DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs>? = null

    private var defenderAgentAutoProvisioningFlag: Output<Boolean>? = null

    private var nativeCloudConnection:
        Output<DefenderForContainersGcpOfferingNativeCloudConnectionArgs>? = null

    private var offeringType: Output<String>? = null

    private var policyAgentAutoProvisioningFlag: Output<Boolean>? = null

    /**
     * @param value Is audit logs data collection enabled
     */
    @JvmName("gnqcujrbekfqilkl")
    public suspend fun auditLogsAutoProvisioningFlag(`value`: Output<Boolean>) {
        this.auditLogsAutoProvisioningFlag = value
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("qextqoipalheuucb")
    public suspend
    fun dataPipelineNativeCloudConnection(`value`: Output<DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs>) {
        this.dataPipelineNativeCloudConnection = value
    }

    /**
     * @param value Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
     */
    @JvmName("kgpwcigebryxfwkr")
    public suspend fun defenderAgentAutoProvisioningFlag(`value`: Output<Boolean>) {
        this.defenderAgentAutoProvisioningFlag = value
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("xkxlclhvwmmhsnxh")
    public suspend
    fun nativeCloudConnection(`value`: Output<DefenderForContainersGcpOfferingNativeCloudConnectionArgs>) {
        this.nativeCloudConnection = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForContainersGcp'.
     */
    @JvmName("mwfjnspyggvanyie")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value Is Policy Kubernetes agent auto provisioning enabled
     */
    @JvmName("yyeyudsawrickfbg")
    public suspend fun policyAgentAutoProvisioningFlag(`value`: Output<Boolean>) {
        this.policyAgentAutoProvisioningFlag = value
    }

    /**
     * @param value Is audit logs data collection enabled
     */
    @JvmName("jyjhqpvawmaxpgfo")
    public suspend fun auditLogsAutoProvisioningFlag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditLogsAutoProvisioningFlag = mapped
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("ovyafjwnatxnbsap")
    public suspend
    fun dataPipelineNativeCloudConnection(`value`: DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPipelineNativeCloudConnection = mapped
    }

    /**
     * @param argument The native cloud connection configuration
     */
    @JvmName("pfkenrxtprrtkcyv")
    public suspend
    fun dataPipelineNativeCloudConnection(argument: suspend DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DefenderForContainersGcpOfferingDataPipelineNativeCloudConnectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataPipelineNativeCloudConnection = mapped
    }

    /**
     * @param value Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
     */
    @JvmName("txanbkbydisnsant")
    public suspend fun defenderAgentAutoProvisioningFlag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenderAgentAutoProvisioningFlag = mapped
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("mqhstvslinqwfdek")
    public suspend
    fun nativeCloudConnection(`value`: DefenderForContainersGcpOfferingNativeCloudConnectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nativeCloudConnection = mapped
    }

    /**
     * @param argument The native cloud connection configuration
     */
    @JvmName("expqndcipjlvjbia")
    public suspend
    fun nativeCloudConnection(argument: suspend DefenderForContainersGcpOfferingNativeCloudConnectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DefenderForContainersGcpOfferingNativeCloudConnectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nativeCloudConnection = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForContainersGcp'.
     */
    @JvmName("irxgpfhofnfxcfiu")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    /**
     * @param value Is Policy Kubernetes agent auto provisioning enabled
     */
    @JvmName("bjmwospxphmwlgyo")
    public suspend fun policyAgentAutoProvisioningFlag(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyAgentAutoProvisioningFlag = mapped
    }

    internal fun build(): DefenderForContainersGcpOfferingArgs = DefenderForContainersGcpOfferingArgs(
        auditLogsAutoProvisioningFlag = auditLogsAutoProvisioningFlag,
        dataPipelineNativeCloudConnection = dataPipelineNativeCloudConnection,
        defenderAgentAutoProvisioningFlag = defenderAgentAutoProvisioningFlag,
        nativeCloudConnection = nativeCloudConnection,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
        policyAgentAutoProvisioningFlag = policyAgentAutoProvisioningFlag,
    )
}
