@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Defender for Databases GCP offering configurations
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property defenderForDatabasesArcAutoProvisioning The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDatabasesGcp'.
 */
public data class DefenderForDatabasesGcpOfferingArgs(
    public val arcAutoProvisioning: Output<DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs>? =
        null,
    public val defenderForDatabasesArcAutoProvisioning:
    Output<DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs>? = null,
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArgs.builder()
            .arcAutoProvisioning(
                arcAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defenderForDatabasesArcAutoProvisioning(
                defenderForDatabasesArcAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForDatabasesGcpOfferingArgs].
 */
@PulumiTagMarker
public class DefenderForDatabasesGcpOfferingArgsBuilder internal constructor() {
    private var arcAutoProvisioning: Output<DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs>? =
        null

    private var defenderForDatabasesArcAutoProvisioning:
        Output<DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs>? = null

    private var offeringType: Output<String>? = null

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("xhxvqilmxxkutqhx")
    public suspend
    fun arcAutoProvisioning(`value`: Output<DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs>) {
        this.arcAutoProvisioning = value
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("iixkuuhqrdhodrbp")
    public suspend
    fun defenderForDatabasesArcAutoProvisioning(`value`: Output<DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs>) {
        this.defenderForDatabasesArcAutoProvisioning = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDatabasesGcp'.
     */
    @JvmName("gycsfqaophdpydsl")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("aedlrlsijwjkffou")
    public suspend
    fun arcAutoProvisioning(`value`: DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param argument The ARC autoprovisioning configuration
     */
    @JvmName("sybdupyckwhqdrpm")
    public suspend
    fun arcAutoProvisioning(argument: suspend DefenderForDatabasesGcpOfferingArcAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForDatabasesGcpOfferingArcAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("ajbnmujgavdafdqk")
    public suspend
    fun defenderForDatabasesArcAutoProvisioning(`value`: DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenderForDatabasesArcAutoProvisioning = mapped
    }

    /**
     * @param argument The native cloud connection configuration
     */
    @JvmName("xcdlqgjyhghbhgce")
    public suspend
    fun defenderForDatabasesArcAutoProvisioning(argument: suspend DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped =
            DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioningArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defenderForDatabasesArcAutoProvisioning = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDatabasesGcp'.
     */
    @JvmName("qfqffewiosjcyrxq")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): DefenderForDatabasesGcpOfferingArgs = DefenderForDatabasesGcpOfferingArgs(
        arcAutoProvisioning = arcAutoProvisioning,
        defenderForDatabasesArcAutoProvisioning = defenderForDatabasesArcAutoProvisioning,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
