@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForDevOpsGitLabOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Defender for DevOps for Gitlab offering
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDevOpsGitLab'.
 */
public data class DefenderForDevOpsGitLabOfferingArgs(
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForDevOpsGitLabOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForDevOpsGitLabOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderForDevOpsGitLabOfferingArgs.builder()
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForDevOpsGitLabOfferingArgs].
 */
@PulumiTagMarker
public class DefenderForDevOpsGitLabOfferingArgsBuilder internal constructor() {
    private var offeringType: Output<String>? = null

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDevOpsGitLab'.
     */
    @JvmName("auxbsfagdpighhil")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDevOpsGitLab'.
     */
    @JvmName("odnsjcrpswwhprai")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): DefenderForDevOpsGitLabOfferingArgs = DefenderForDevOpsGitLabOfferingArgs(
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
