@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForDevOpsGithubOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Defender for DevOps for Github offering
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDevOpsGithub'.
 */
public data class DefenderForDevOpsGithubOfferingArgs(
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForDevOpsGithubOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForDevOpsGithubOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderForDevOpsGithubOfferingArgs.builder()
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForDevOpsGithubOfferingArgs].
 */
@PulumiTagMarker
public class DefenderForDevOpsGithubOfferingArgsBuilder internal constructor() {
    private var offeringType: Output<String>? = null

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDevOpsGithub'.
     */
    @JvmName("tphpgfdxhspfovdd")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDevOpsGithub'.
     */
    @JvmName("jwgokhwdgeqlbfio")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): DefenderForDevOpsGithubOfferingArgs = DefenderForDevOpsGithubOfferingArgs(
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
