@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArcAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The ARC autoprovisioning configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property configuration Configuration for servers Arc auto provisioning
 * @property enabled Is arc auto provisioning enabled
 */
public data class DefenderForServersAwsOfferingArcAutoProvisioningArgs(
    public val cloudRoleArn: Output<String>? = null,
    public val configuration: Output<DefenderForServersAwsOfferingConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArcAutoProvisioningArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArcAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArcAutoProvisioningArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingArcAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingArcAutoProvisioningArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    private var configuration: Output<DefenderForServersAwsOfferingConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("pwkiuslcfwouiikl")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("otcnwnxostyanwby")
    public suspend
    fun configuration(`value`: Output<DefenderForServersAwsOfferingConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("pxngsqmcgtflctqa")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("cjjmchterarywqtn")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("yqrwlktvecbtadcr")
    public suspend fun configuration(`value`: DefenderForServersAwsOfferingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration for servers Arc auto provisioning
     */
    @JvmName("chkqicnedpvjbmvb")
    public suspend
    fun configuration(argument: suspend DefenderForServersAwsOfferingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersAwsOfferingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("banmugkmdurilspx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingArcAutoProvisioningArgs =
        DefenderForServersAwsOfferingArcAutoProvisioningArgs(
            cloudRoleArn = cloudRoleArn,
            configuration = configuration,
            enabled = enabled,
        )
}
