@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVaAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Vulnerability Assessment autoprovisioning configuration
 * @property configuration configuration for Vulnerability Assessment autoprovisioning
 * @property enabled Is Vulnerability Assessment auto provisioning enabled
 */
public data class DefenderForServersAwsOfferingVaAutoProvisioningArgs(
    public val configuration: Output<DefenderForServersAwsOfferingConfigurationConfigurationArgs>? =
        null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVaAutoProvisioningArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVaAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingVaAutoProvisioningArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingVaAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingVaAutoProvisioningArgsBuilder internal constructor() {
    private var configuration: Output<DefenderForServersAwsOfferingConfigurationConfigurationArgs>? =
        null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value configuration for Vulnerability Assessment autoprovisioning
     */
    @JvmName("cyocectegaghdevh")
    public suspend
    fun configuration(`value`: Output<DefenderForServersAwsOfferingConfigurationConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is Vulnerability Assessment auto provisioning enabled
     */
    @JvmName("nkcstgudcvuxiswq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value configuration for Vulnerability Assessment autoprovisioning
     */
    @JvmName("wqbmmahyvbsqxgam")
    public suspend
    fun configuration(`value`: DefenderForServersAwsOfferingConfigurationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument configuration for Vulnerability Assessment autoprovisioning
     */
    @JvmName("vkifmxkkaixycyes")
    public suspend
    fun configuration(argument: suspend DefenderForServersAwsOfferingConfigurationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DefenderForServersAwsOfferingConfigurationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is Vulnerability Assessment auto provisioning enabled
     */
    @JvmName("mfdclasstadloxen")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingVaAutoProvisioningArgs =
        DefenderForServersAwsOfferingVaAutoProvisioningArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
